/*
 * Decompiled with CFR 0.152.
 */
package com.walker.jdbc;

import com.walker.db.DatabaseType;

public class Constants {
    public static final String SQL_ORDER_BY = " order by ";
    public static final String DRIVER_NAME_DERBY = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String DRIVER_NAME_MYSQL = "com.mysql.cj.jdbc.Driver";
    public static final String DRIVER_NAME_ORACLE = "oracle.jdbc.driver.OracleDriver";
    public static final String DRIVER_NAME_POSTGRES = "org.postgresql.Driver";
    public static final String DRIVER_NAME_SQLSERVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    public static final String DRIVER_NAME_DAMENG = "dm.jdbc.driver.DmDriver";
    public static final int DEFAULT_PORT_DERBY = 0;
    public static final int DEFAULT_PORT_MYSQL = 3306;
    public static final int DEFAULT_PORT_ORACLE = 1521;
    public static final int DEFAULT_PORT_POSTGRES = 5432;
    public static final int DEFAULT_PORT_SQLSERVER = 1433;
    public static final int DEFAULT_PORT_DAMENG = 5236;
    public static final String PO_FIELD_PARAMETER = "parameter";
    public static final String SQL_NAME_WHERE = "where";
    public static final String SQL_NAME_AND = "and";
    public static final String SQL_NAME_LIKE = "like";

    public static final String getJdbcUrl(DatabaseType databaseType, String databaseName, String ip, int port) {
        StringBuilder url = new StringBuilder();
        if (databaseType == DatabaseType.DERBY) {
            url.append("jdbc:derby:").append(databaseName);
        } else if (databaseType == DatabaseType.MYSQL) {
            url.append("jdbc:mysql://").append(ip).append(":").append(port == 0 ? 3306 : port).append("/").append(databaseName);
            if (url.indexOf("?") >= 0) {
                url.append("&autoReconnect=true");
                url.append("&failOverReadOnly=false");
            } else {
                url.append("?autoReconnect=true");
                url.append("&failOverReadOnly=false");
            }
        } else if (databaseType == DatabaseType.ORACLE) {
            url.append("jdbc:oracle:thin:@").append(ip).append(":").append(port == 0 ? 1521 : port).append(":").append(databaseName);
        } else if (databaseType == DatabaseType.POSTGRES) {
            url.append("jdbc:postgresql://").append(ip).append(":").append(port == 0 ? 5432 : port).append("/").append(databaseName);
        } else if (databaseType == DatabaseType.SQLSERVER) {
            url.append("jdbc:sqlserver://").append(ip).append(":").append(port == 0 ? 5432 : port).append(";DatabaseName=").append(databaseName);
        } else if (databaseType == DatabaseType.DAMENG) {
            url.append("jdbc:dm://").append(ip).append(":").append(port == 0 ? 5432 : port).append("?SCHEMA=").append(databaseName);
        } else {
            throw new IllegalArgumentException("unsupported database type: " + databaseType);
        }
        return url.toString();
    }

    public static final String getDriverClassName(DatabaseType databaseType) {
        String driverName = null;
        if (databaseType == DatabaseType.DERBY) {
            driverName = DRIVER_NAME_DERBY;
        } else if (databaseType == DatabaseType.MYSQL) {
            driverName = DRIVER_NAME_MYSQL;
        } else if (databaseType == DatabaseType.ORACLE) {
            driverName = DRIVER_NAME_ORACLE;
        } else if (databaseType == DatabaseType.POSTGRES) {
            driverName = DRIVER_NAME_POSTGRES;
        } else if (databaseType == DatabaseType.SQLSERVER) {
            driverName = DRIVER_NAME_SQLSERVER;
        } else if (databaseType == DatabaseType.DAMENG) {
            driverName = DRIVER_NAME_DAMENG;
        } else {
            throw new IllegalArgumentException("unsupported database type: " + databaseType);
        }
        return driverName;
    }
}

