/*
 * Decompiled with CFR 0.152.
 */
package com.walker.jdbc.config;

import com.walker.db.DatabaseType;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.jdbc.DataSourceMeta;
import com.walker.jdbc.JdbcInspector;
import com.walker.jdbc.config.DatabaseProperties;
import com.walker.jdbc.dao.PaginationHelper;
import com.walker.jdbc.dao.SqlDaoSupport;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@Configuration
@Aspect
public class DatabaseConfig {
    private static final String AOP_POINTCUT_EXPRESSION = "execution (* com..*ServiceImpl.*(..))";
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private DataSource dataSource;
    private TransactionManager transactionManager;
    private DatabaseType databaseType = null;

    @Autowired
    public DatabaseConfig(DataSource dataSource, TransactionManager transactionManager) {
        this.dataSource = dataSource;
        this.transactionManager = transactionManager;
    }

    @Bean
    public DatabaseProperties databaseProperties() {
        return new DatabaseProperties();
    }

    @Bean
    public JdbcInspector jdbcInspector(DatabaseProperties databaseProperties) {
        DataSourceMeta defaultDataSource = (DataSourceMeta)((Object)this.dataSource);
        DatabaseType databaseType = defaultDataSource.getDatabaseType();
        defaultDataSource.setUsername(databaseProperties.getUsername());
        defaultDataSource.setPassword(databaseProperties.getPassword());
        JdbcInspector.getInstance().setPrimaryDatabaseType(databaseType);
        JdbcInspector.getInstance().setPrimaryDataSourceMeta(defaultDataSource);
        this.logger.info("\u521b\u5efa: JdbcInspector, username=" + databaseProperties.getUsername());
        return JdbcInspector.getInstance();
    }

    @Bean
    public TransactionInterceptor txAdvice() {
        if (this.dataSource == null) {
            throw new ApplicationRuntimeException("\u672a\u627e\u5230\u6570\u636e\u6e90\uff1aDataSource");
        }
        if (!(this.dataSource instanceof DataSourceMeta)) {
            throw new ApplicationRuntimeException("\u914d\u7f6e\u7684\u6570\u636e\u6e90\u5fc5\u987b\u5b9e\u73b0\u63a5\u53e3\uff1aDataSourceMeta!");
        }
        this.databaseType = ((DataSourceMeta)((Object)this.dataSource)).getDatabaseType();
        this.logger.info("dataType = " + this.databaseType);
        this.jdbcInspector(this.databaseProperties());
        DefaultTransactionAttribute txAttr_REQUIRED = new DefaultTransactionAttribute();
        txAttr_REQUIRED.setPropagationBehavior(0);
        DefaultTransactionAttribute txAttr_REQUIRED_READONLY = new DefaultTransactionAttribute();
        txAttr_REQUIRED_READONLY.setPropagationBehavior(0);
        txAttr_REQUIRED_READONLY.setReadOnly(true);
        if (this.databaseType.getTypeIndex() != DatabaseType.SQLITE.getTypeIndex()) {
            txAttr_REQUIRED.setIsolationLevel(2);
            txAttr_REQUIRED_READONLY.setIsolationLevel(2);
        }
        NameMatchTransactionAttributeSource source = new NameMatchTransactionAttributeSource();
        source.addTransactionalMethod("add*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("insert*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("save*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("start*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("delete*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("update*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("create*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("exec*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("set*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("clear*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("clean*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("sync*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("send*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("submit*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("init*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("retract*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("back*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("leave*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("enter*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("next*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("sign*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("upload*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("copy*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("batch*", (TransactionAttribute)txAttr_REQUIRED);
        source.addTransactionalMethod("get*", (TransactionAttribute)txAttr_REQUIRED_READONLY);
        source.addTransactionalMethod("query*", (TransactionAttribute)txAttr_REQUIRED_READONLY);
        source.addTransactionalMethod("find*", (TransactionAttribute)txAttr_REQUIRED_READONLY);
        source.addTransactionalMethod("list*", (TransactionAttribute)txAttr_REQUIRED_READONLY);
        source.addTransactionalMethod("count*", (TransactionAttribute)txAttr_REQUIRED_READONLY);
        source.addTransactionalMethod("is*", (TransactionAttribute)txAttr_REQUIRED_READONLY);
        source.addTransactionalMethod("sql*", (TransactionAttribute)txAttr_REQUIRED_READONLY);
        source.addTransactionalMethod("*", (TransactionAttribute)txAttr_REQUIRED_READONLY);
        return new TransactionInterceptor(this.transactionManager, (TransactionAttributeSource)source);
    }

    @Bean
    @Lazy
    public Advisor txAdviceAdvisor() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(AOP_POINTCUT_EXPRESSION);
        return new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)this.txAdvice());
    }

    @Bean(value={"jdbcTemplate"})
    public JdbcTemplate jdbcTemplate() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate();
        try {
            jdbcTemplate.setDataSource(this.dataSource);
            jdbcTemplate.setLazyInit(false);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return jdbcTemplate;
    }

    @Bean(value={"namedParameterJdbcTemplate"})
    public NamedParameterJdbcTemplate namedParameterJdbcTemplate() {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        return namedParameterJdbcTemplate;
    }

    @Bean(value={"paginationHelper"})
    public PaginationHelper paginationHelper() {
        PaginationHelper paginationHelper = new PaginationHelper();
        paginationHelper.setType(this.databaseType.toString());
        return paginationHelper;
    }

    @Bean(value={"dao"})
    public SqlDaoSupport jdbcDaoImpl(DatabaseProperties databaseProperties) {
        SqlDaoSupport jdbcDao = new SqlDaoSupport();
        jdbcDao.setJdbcTemplate(this.jdbcTemplate());
        jdbcDao.setNamedParameterJdbcTemplate(this.namedParameterJdbcTemplate());
        jdbcDao.setPaginationHelper(this.paginationHelper());
        jdbcDao.setShowSql(databaseProperties.isShowSql());
        return jdbcDao;
    }
}

