/*
 * Decompiled with CFR 0.152.
 */
package com.walker.jdbc.dao;

import com.walker.db.Sorts;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.db.page.MapPager;
import com.walker.db.page.PageSearch;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BaseDao;
import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.BasePo;
import com.walker.jdbc.ColumnMapRowMapper;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.dao.PaginationHelper;
import com.walker.jdbc.dao.PersistenceException;
import com.walker.jdbc.util.JdbcUtils;
import com.walker.jdbc.util.StringSqlUtils;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.Assert;

public class JdbcDaoImpl
implements BaseDao {
    protected final transient Logger logger = LoggerFactory.getLogger(JdbcDaoImpl.class);
    private static final Pattern ARRAY_PARAMETER_PLACEHOLDER = Pattern.compile("\\?");
    private JdbcTemplate jdbcTemplate;
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private PaginationHelper paginationHelper;
    private boolean showSql = true;

    public PaginationHelper getPaginationHelper() {
        return this.paginationHelper;
    }

    public void setPaginationHelper(PaginationHelper paginationHelper) {
        this.paginationHelper = paginationHelper;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public NamedParameterJdbcTemplate getNamedParameterJdbcTemplate() {
        return this.namedParameterJdbcTemplate;
    }

    public void setNamedParameterJdbcTemplate(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    private <T extends BasePo<T>> BaseMapper<T> convertToMapper(T basePo) {
        return JdbcUtils.getInstance(basePo);
    }

    @Override
    public <T extends BasePo<T>> int insert(T po) throws DataAccessException {
        Assert.notNull(po, (String)"po \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BaseMapper<T> pomapper = this.convertToMapper(po);
        Assert.notNull((Object)pomapper.getPkValue_(), (String)(po.getClass().getCanonicalName() + "\u4e3b\u952e " + pomapper.getPkName_() + " \u4e0d\u80fd\u4e3a\u7a7a"));
        SqlAndParameters sp = pomapper.getInsertSql_();
        this.printSql(sp);
        return this.namedParameterJdbcTemplate.update(sp.getSql(), (Map)sp.getParameters());
    }

    @Override
    public <T extends BasePo<T>> int insertBatch(List<T> poList) throws DataAccessException {
        if (poList == null || poList.size() == 0) {
            throw new IllegalArgumentException("poList is required!");
        }
        String sql = null;
        Map[] parameters = new HashMap[poList.size()];
        BasePo basePo = null;
        BaseMapper<BasePo> baseMapper = null;
        SqlAndParameters sp = null;
        for (int i = 0; i < poList.size(); ++i) {
            basePo = (BasePo)poList.get(i);
            baseMapper = this.convertToMapper(basePo);
            sp = baseMapper.getInsertSql_();
            if (sql == null) {
                sql = sp.getSql();
            }
            parameters[i] = (Map)sp.getParameters();
        }
        int[] result = this.namedParameterJdbcTemplate.batchUpdate(sql, parameters);
        if (result != null) {
            return result[0];
        }
        return 0;
    }

    private void printSql(SqlAndParameters sp) {
        if (this.isShowSql()) {
            this.logger.info("{}", (Object)sp.toPrintSql());
        }
    }

    @Override
    public <T extends BasePo<T>> int insert(List<T> poList) throws DataAccessException {
        Assert.notNull(poList, (String)"poList \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        int sum = 0;
        for (BasePo po : poList) {
            sum += this.insert(po);
        }
        return sum;
    }

    @Override
    public <T extends BasePo<T>> int update(T po) throws DataAccessException {
        Assert.notNull(po, (String)"po \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BaseMapper<T> pomapper = this.convertToMapper(po);
        Assert.notNull((Object)pomapper.getPkValue_(), (String)(po.getClass().getCanonicalName() + "\u4e3b\u952e " + pomapper.getPkName_() + " \u4e0d\u80fd\u4e3a\u7a7a"));
        SqlAndParameters sp = pomapper.getUpdateSql_();
        this.printSql(sp);
        return this.namedParameterJdbcTemplate.update(sp.getSql(), (Map)sp.getParameters());
    }

    @Override
    public <T extends BasePo<T>> int save(T po) {
        BaseMapper<T> pomapper = this.convertToMapper(po);
        SqlAndParameters sp = null;
        if (pomapper.getPkValue_() == null || "".equals(pomapper.getPkValue_())) {
            pomapper.setPkValue((Object)NumberGenerator.getLongSequenceNumber());
            po.setPkValue(pomapper.getPkValue_());
            sp = pomapper.getInsertSql_();
        } else {
            sp = pomapper.getUpdateSql_();
        }
        this.printSql(sp);
        return this.namedParameterJdbcTemplate.update(sp.getSql(), (Map)sp.getParameters());
    }

    @Override
    public <T extends BasePo<T>> int update(List<T> poList) throws DataAccessException {
        Assert.notNull(poList, (String)"poList \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        int sum = 0;
        for (BasePo po : poList) {
            sum += this.update(po);
        }
        return sum;
    }

    @Override
    public <T extends BasePo<T>> int updateBatch(List<T> poList) throws DataAccessException {
        if (poList == null || poList.size() == 0) {
            return 0;
        }
        String sql = null;
        Map[] parameters = new HashMap[poList.size()];
        BasePo basePo = null;
        BaseMapper<BasePo> baseMapper = null;
        SqlAndParameters sp = null;
        for (int i = 0; i < poList.size(); ++i) {
            basePo = (BasePo)poList.get(i);
            baseMapper = this.convertToMapper(basePo);
            sp = baseMapper.getUpdateSql_();
            if (sql == null) {
                sql = sp.getSql();
            }
            parameters[i] = (Map)sp.getParameters();
        }
        int[] result = this.namedParameterJdbcTemplate.batchUpdate(sql, parameters);
        if (result != null) {
            return result[0];
        }
        return 0;
    }

    @Override
    public <T extends BasePo<T>> int update(T po, String where, Map<String, Object> parameters) throws DataAccessException {
        Assert.notNull(po, (String)"po \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)where, (String)"where \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull(parameters, (String)"parameters \u4e0d\u80fd\u4e3a\u7a7a!");
        BaseMapper<T> pomapper = this.convertToMapper(po);
        SqlAndParameters sp = pomapper.getUpdateSql_(where, parameters);
        this.printSql(sp);
        return this.namedParameterJdbcTemplate.update(sp.getSql(), (Map)sp.getParameters());
    }

    @Override
    public <T extends BasePo<T>> int update(T po, String where, Object[] parameters) throws DataAccessException {
        Assert.notNull(po, (String)"po \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)where, (String)"where \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)parameters, (String)"parameters \u4e0d\u80fd\u4e3a\u7a7a!");
        BaseMapper<T> pomapper = this.convertToMapper(po);
        SqlAndParameters sp = pomapper.getUpdateSql_(where, parameters);
        this.printSql(sp);
        return this.jdbcTemplate.update(sp.getSql(), (Object[])sp.getParameters());
    }

    @Override
    public <T extends BasePo<T>> int delete(T po) throws DataAccessException {
        Assert.notNull(po, (String)"po \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BaseMapper<T> pomapper = this.convertToMapper(po);
        Assert.notNull((Object)pomapper.getPkValue_(), (String)(po.getClass().getCanonicalName() + " \u4e3b\u952e " + pomapper.getPkName_() + " \u4e0d\u80fd\u4e3a\u7a7a"));
        SqlAndParameters sp = pomapper.getDeleteSql_();
        this.printSql(sp);
        return this.namedParameterJdbcTemplate.update(sp.getSql(), (Map)sp.getParameters());
    }

    @Override
    public <T extends BasePo<T>> int delete(List<T> poList) throws DataAccessException {
        Assert.notNull(poList, (String)"poList \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        int sum = 0;
        for (BasePo po : poList) {
            sum += this.delete(po);
        }
        return sum;
    }

    @Override
    public <T extends BasePo<T>> int delete(T po, String where, Map<String, Object> parameters) throws DataAccessException {
        Assert.notNull(po, (String)"po \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)where, (String)"where \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull(parameters, (String)"parameters \u4e0d\u80fd\u4e3a\u7a7a!");
        BaseMapper<T> pomapper = this.convertToMapper(po);
        SqlAndParameters sp = pomapper.getDeleteSql_(where, parameters);
        this.printSql(sp);
        return this.namedParameterJdbcTemplate.update(sp.getSql(), (Map)sp.getParameters());
    }

    @Override
    public <T extends BasePo<T>> int delete(T po, String where, Object[] parameters) throws DataAccessException {
        Assert.notNull(po, (String)"po \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)where, (String)"where \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)parameters, (String)"parameters \u4e0d\u80fd\u4e3a\u7a7a!");
        BaseMapper<T> pomapper = this.convertToMapper(po);
        SqlAndParameters sp = pomapper.getDeleteSql_(where, parameters);
        this.printSql(sp);
        return this.jdbcTemplate.update(sp.getSql(), (Object[])sp.getParameters());
    }

    @Override
    public <T extends BasePo<T>> T get(T po) throws DataAccessException {
        Assert.notNull(po, (String)"po \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BaseMapper<T> pomapper = this.convertToMapper(po);
        Assert.notNull((Object)pomapper.getPkValue_(), (String)(po.getClass().getCanonicalName() + "\u4e3b\u952e " + pomapper.getPkName_() + " \u4e0d\u80fd\u4e3a\u7a7a"));
        SqlAndParameters sp = pomapper.getSingleSql_();
        List<T> list = this.select(sp.getSql(), (Map<String, Object>)((Map)sp.getParameters()), po);
        return this.getUnique(list);
    }

    @Override
    public <T extends BasePo<T>> T get(T po, String where, Map<String, Object> parameters) throws DataAccessException {
        Assert.notNull(po, (String)"po \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)where, (String)"where \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull(parameters, (String)"parameters \u4e0d\u80fd\u4e3a\u7a7a!");
        BaseMapper<T> pomapper = this.convertToMapper(po);
        SqlAndParameters sp = pomapper.getSelectSql_(where, parameters);
        List<T> list = this.select(sp.getSql(), (Map<String, Object>)((Map)sp.getParameters()), po);
        return this.getUnique(list);
    }

    @Override
    public <T extends BasePo<T>> T get(T po, String where, Object[] parameters) throws DataAccessException {
        Assert.notNull(po, (String)"po \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)where, (String)"where \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)parameters, (String)"parameters \u4e0d\u80fd\u4e3a\u7a7a!");
        BaseMapper<T> pomapper = this.convertToMapper(po);
        SqlAndParameters sp = pomapper.getSelectSql_(where, parameters);
        List<T> list = this.select(sp.getSql(), (Object[])sp.getParameters(), po);
        return this.getUnique(list);
    }

    @Override
    public <T> T get(String sql, Map<String, Object> parameters, RowMapper<T> rowMapper) throws DataAccessException {
        Assert.notNull((Object)sql, (String)"sql \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull(parameters, (String)"parameters \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull(rowMapper, (String)"rowMapper \u4e0d\u80fd\u4e3a\u7a7a!");
        List<RowMapper<T>> list = this.select(sql, parameters, (T)rowMapper);
        return (T)this.getUnique(list);
    }

    @Override
    public <T extends BasePo<T>> T get(String sql, Map<String, Object> parameters, T po) throws DataAccessException {
        return (T)((BasePo)this.get(sql, parameters, (T)this.convertToMapper(po)));
    }

    @Override
    public <T> T get(String sql, Object[] parameters, RowMapper<T> rowMapper) throws DataAccessException {
        Assert.notNull((Object)sql, (String)"sql \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)parameters, (String)"parameters \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull(rowMapper, (String)"rowMapper \u4e0d\u80fd\u4e3a\u7a7a!");
        List<RowMapper<T>> list = this.select(sql, parameters, (T)rowMapper);
        return (T)this.getUnique(list);
    }

    @Override
    public <T extends BasePo<T>> T get(String sql, Object[] parameters, T po) throws DataAccessException {
        return (T)((BasePo)this.get(sql, parameters, (T)this.convertToMapper(po)));
    }

    @Override
    public Map<String, Object> get(String sql, Map<String, Object> parameters) throws DataAccessException {
        Assert.notNull((Object)sql, (String)"sql \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull(parameters, (String)"parameters \u4e0d\u80fd\u4e3a\u7a7a!");
        List<Map<String, Object>> list = this.select(sql, parameters);
        return this.getUnique(list);
    }

    @Override
    public Map<String, Object> get(String sql, Object[] parameters) throws DataAccessException {
        Assert.notNull((Object)sql, (String)"sql \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)parameters, (String)"parameters \u4e0d\u80fd\u4e3a\u7a7a!");
        List<Map<String, Object>> list = this.select(sql, parameters);
        return this.getUnique(list);
    }

    @Override
    public <T extends BasePo<T>> List<T> select(T po, String where, Map<String, Object> parameters) throws DataAccessException {
        Assert.notNull(po, (String)"po \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull(parameters, (String)"parameters \u4e0d\u80fd\u4e3a\u7a7a!");
        BaseMapper<T> pomapper = this.convertToMapper(po);
        SqlAndParameters sp = pomapper.getSelectSql_(where, parameters);
        return this.select(sp.getSql(), (Map<String, Object>)((Map)sp.getParameters()), po);
    }

    @Override
    public <T extends BasePo<T>> List<T> select(T po, String where, Object[] parameters) throws DataAccessException {
        Assert.notNull(po, (String)"po \u4e0d\u80fd\u4e3a\u7a7a!");
        if (parameters == null) {
            parameters = new Object[]{};
        }
        BaseMapper<T> pomapper = this.convertToMapper(po);
        SqlAndParameters sp = pomapper.getSelectSql_(where, parameters);
        return this.select(sp.getSql(), (Object[])sp.getParameters(), po);
    }

    @Override
    public <T extends BasePo<T>> List<T> select(T po) throws DataAccessException {
        return this.select(po, null);
    }

    @Override
    public <T extends BasePo<T>> List<T> select(T po, Sorts.Sort sort) throws DataAccessException {
        if (po == null) {
            throw new IllegalArgumentException("po is required!");
        }
        Object[] result = JdbcUtils.acquireQueryCondition(po);
        BaseMapper<T> pomapper = this.convertToMapper(po);
        SqlAndParameters sp = pomapper.getSelectSql_(result[0].toString(), (Map)result[1]);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sp.getSql());
            this.logger.debug("fieldNameAndValue={}", result[1]);
        }
        String sql = sort == null ? sp.getSql() : this.paginationHelper.getOrderBySql(sp.getSql(), sort);
        return this.select(sql, (Map<String, Object>)((Map)sp.getParameters()), po);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(T po, String where, Map<String, Object> parameters, int currentPage, int pageSize) throws DataAccessException {
        Assert.notNull(po, (String)"po \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull(parameters, (String)"parameters \u4e0d\u80fd\u4e3a\u7a7a!");
        if (parameters == null) {
            parameters = new HashMap<String, Object>(2);
        }
        BaseMapper<T> pomapper = this.convertToMapper(po);
        SqlAndParameters sp = pomapper.getSelectSql_(where, parameters);
        return this.selectSplit(sp.getSql(), (Map<String, Object>)((Map)sp.getParameters()), currentPage, pageSize, po);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(T po, int currentPage, int pageSize, Sorts.Sort sort) throws DataAccessException {
        Assert.notNull(po, (String)"po \u4e0d\u80fd\u4e3a\u7a7a!");
        Object[] result = JdbcUtils.acquireQueryCondition(po);
        BaseMapper<T> pomapper = this.convertToMapper(po);
        SqlAndParameters sp = pomapper.getSelectSql_(result[0].toString(), (Map)result[1]);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sp.getSql());
            this.logger.debug("fieldNameAndValue={}", result[1]);
        }
        String sql = sort == null ? sp.getSql() : this.paginationHelper.getOrderBySql(sp.getSql(), sort);
        return this.selectSplit(sql, (Map<String, Object>)((Map)sp.getParameters()), currentPage, pageSize, po);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(T po, int currentPage, int pageSize) throws DataAccessException {
        return this.selectSplit(po, currentPage, pageSize, (Sorts.Sort)null);
    }

    @Override
    public List<Map<String, Object>> select(String sql, Object[] parameters) throws DataAccessException {
        Assert.notNull((Object)sql, (String)"sql \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)parameters, (String)"parameters \u4e0d\u80fd\u4e3a\u7a7a!");
        this.printSql(new SqlAndParameters(sql, (Object)parameters));
        return this.jdbcTemplate.query(sql, (RowMapper)new ColumnMapRowMapper(), parameters);
    }

    @Override
    public <T> List<T> select(String sql, Object[] parameters, RowMapper<T> rowMapper) throws DataAccessException {
        Assert.notNull((Object)sql, (String)"sql \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)parameters, (String)"parameters \u4e0d\u80fd\u4e3a\u7a7a!");
        this.printSql(new SqlAndParameters(sql, (Object)parameters));
        return this.jdbcTemplate.query(sql, rowMapper, parameters);
    }

    @Override
    public <T extends BasePo<T>> List<T> select(String sql, Object[] parameters, T po) throws DataAccessException {
        return this.select(sql, parameters, (T)this.convertToMapper(po));
    }

    @Override
    public MapPager selectSplit(String sql, Object[] parameters, int currentPage, int pageSize, Sorts.Sort sort) throws DataAccessException {
        Assert.notNull((Object)sql, (String)"sql \u4e0d\u80fd\u4e3a\u7a7a!");
        if (parameters == null) {
            parameters = new Object[]{};
        }
        int cnt = this.queryForInt("select count(1) from (" + sql + ")  total", parameters);
        MapPager pager = ListPageContext.createMapPager(null, (int)currentPage, (int)pageSize, (int)cnt);
        SqlAndParameters<Object[]> sp = this.paginationHelper.getSqlPagingQuery(sql, parameters, (GenericPager<?>)pager, sort);
        this.printSql(sp);
        List data = this.jdbcTemplate.query(sp.getSql(), (RowMapper)new ColumnMapRowMapper(), (Object[])sp.getParameters());
        pager.setDatas(data);
        return pager;
    }

    @Override
    public MapPager selectSplit(String sql, Object[] parameters, int currentPage, int pageSize) throws DataAccessException {
        return this.selectSplit(sql, parameters, currentPage, pageSize, (Sorts.Sort)null);
    }

    @Override
    public <T> GenericPager<T> selectSplit(String sql, Object[] parameters, int currentPage, int pageSize, RowMapper<T> rowMapper, Sorts.Sort sort) throws DataAccessException {
        Assert.notNull((Object)sql, (String)"sql \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull(rowMapper, (String)"rowMapper \u4e0d\u80fd\u4e3a\u7a7a!");
        if (parameters == null) {
            parameters = new Object[]{};
        }
        int cnt = this.queryForInt("select count(1) from (" + sql + ") total", parameters);
        GenericPager pager = ListPageContext.createGenericPager((int)currentPage, (int)pageSize, (int)cnt);
        SqlAndParameters<Object[]> sp = this.paginationHelper.getSqlPagingQuery(sql, parameters, pager, sort);
        this.printSql(sp);
        List data = this.jdbcTemplate.query(sp.getSql(), rowMapper, (Object[])sp.getParameters());
        pager.setDatas(data);
        return pager;
    }

    @Override
    public <T> GenericPager<T> selectSplit(String sql, Object[] parameters, int currentPage, int pageSize, RowMapper<T> rowMapper) throws DataAccessException {
        return this.selectSplit(sql, parameters, currentPage, pageSize, rowMapper, null);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(String sql, Object[] parameters, int currentPage, int pageSize, T po) throws DataAccessException {
        return this.selectSplit(sql, parameters, currentPage, pageSize, (T)this.convertToMapper(po));
    }

    @Override
    public List<Map<String, Object>> select(String sql, Map<String, Object> parameters) throws DataAccessException {
        Assert.notNull((Object)sql, (String)"sql \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull(parameters, (String)"parameters \u4e0d\u80fd\u4e3a\u7a7a!");
        this.printSql(new SqlAndParameters(sql, parameters));
        return this.namedParameterJdbcTemplate.query(sql, parameters, (RowMapper)new ColumnMapRowMapper());
    }

    @Override
    public <T> List<T> select(String sql, Map<String, Object> parameters, RowMapper<T> mapper) throws DataAccessException {
        Assert.notNull((Object)sql, (String)"sql \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull(parameters, (String)"parameters \u4e0d\u80fd\u4e3a\u7a7a!");
        this.printSql(new SqlAndParameters(sql, parameters));
        return this.namedParameterJdbcTemplate.query(sql, parameters, mapper);
    }

    @Override
    public <T extends BasePo<T>> List<T> select(String sql, Map<String, Object> parameters, T po) throws DataAccessException {
        return this.select(sql, parameters, (T)this.convertToMapper(po));
    }

    @Override
    public MapPager selectSplit(String sql, Map<String, Object> parameters, int currentPage, int pageSize, Sorts.Sort sort) throws DataAccessException {
        Assert.notNull((Object)sql, (String)"sql \u4e0d\u80fd\u4e3a\u7a7a!");
        if (parameters == null) {
            parameters = new HashMap<String, Object>(2);
        }
        int cnt = this.queryForInt("select count(1) from (" + sql + ") total", parameters);
        MapPager pager = ListPageContext.createMapPager(null, (int)currentPage, (int)pageSize, (int)cnt);
        SqlAndParameters<Map<String, Object>> sp = this.paginationHelper.getSqlPagingQuery(sql, parameters, (GenericPager<?>)pager, sort);
        this.printSql(sp);
        List data = this.namedParameterJdbcTemplate.query(sp.getSql(), (Map)sp.getParameters(), (RowMapper)new ColumnMapRowMapper());
        pager.setDatas(data);
        return pager;
    }

    @Override
    public MapPager selectSplit(String sql, Map<String, Object> parameters, int currentPage, int pageSize) throws DataAccessException {
        return this.selectSplit(sql, parameters, currentPage, pageSize, (Sorts.Sort)null);
    }

    @Override
    public <T> GenericPager<T> selectSplit(String sql, Map<String, Object> parameters, int currentPage, int pageSize, RowMapper<T> rowMapper, Sorts.Sort sort) throws DataAccessException {
        Assert.notNull((Object)sql, (String)"sql \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull(rowMapper, (String)"rowMapper \u4e0d\u80fd\u4e3a\u7a7a!");
        if (parameters == null) {
            parameters = new HashMap<String, Object>(2);
        }
        int cnt = this.queryForInt("select count(1) from (" + sql + ") total", parameters);
        GenericPager pager = ListPageContext.createGenericPager((int)currentPage, (int)pageSize, (int)cnt);
        SqlAndParameters<Map<String, Object>> sp = this.paginationHelper.getSqlPagingQuery(sql, parameters, pager, sort);
        this.printSql(sp);
        List data = this.namedParameterJdbcTemplate.query(sp.getSql(), (Map)sp.getParameters(), rowMapper);
        pager.setDatas(data);
        return pager;
    }

    @Override
    public <T> GenericPager<T> selectSplit(String sql, Map<String, Object> parameters, RowMapper<T> rowMapper, Sorts.Sort sort) throws DataAccessException {
        PageSearch pageSearch = ListPageContext.getPageSearch();
        if (pageSearch != null) {
            return this.selectSplit(sql, parameters, pageSearch.getPageIndex(), pageSearch.getPageSize(), rowMapper, sort);
        }
        return this.selectSplit(sql, parameters, ListPageContext.getCurrentPageIndex(), ListPageContext.getCurrentPageSize(), rowMapper, sort);
    }

    @Override
    public <T> GenericPager<T> selectSplit(String sql, Map<String, Object> parameters, int currentPage, int pageSize, RowMapper<T> rowMapper) throws DataAccessException {
        return this.selectSplit(sql, parameters, currentPage, pageSize, rowMapper, null);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(String sql, Map<String, Object> parameters, int currentPage, int pageSize, T po) throws DataAccessException {
        return this.selectSplit(sql, parameters, currentPage, pageSize, (T)this.convertToMapper(po));
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(String sql, Map<String, Object> parameters, T po) throws DataAccessException {
        PageSearch pageSearch = ListPageContext.getPageSearch();
        if (pageSearch != null) {
            return this.selectSplit(sql, parameters, pageSearch.getPageIndex(), pageSearch.getPageSize(), po);
        }
        return this.selectSplit(sql, parameters, ListPageContext.getCurrentPageIndex(), ListPageContext.getCurrentPageSize(), po);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(T po, Sorts.Sort sort) throws DataAccessException {
        PageSearch pageSearch = ListPageContext.getPageSearch();
        if (pageSearch != null) {
            return this.selectSplit(po, pageSearch.getPageIndex(), pageSearch.getPageSize(), sort);
        }
        return this.selectSplit(po, ListPageContext.getCurrentPageIndex(), ListPageContext.getCurrentPageSize(), sort);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(T po) throws DataAccessException {
        return this.selectSplit(po, null);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(String sql, Object[] parameters, T po) throws DataAccessException {
        PageSearch pageSearch = ListPageContext.getPageSearch();
        if (pageSearch != null) {
            return this.selectSplit(sql, parameters, pageSearch.getPageIndex(), pageSearch.getPageSize(), po);
        }
        return this.selectSplit(sql, parameters, ListPageContext.getCurrentPageIndex(), ListPageContext.getCurrentPageSize(), po);
    }

    @Override
    public <T> GenericPager<T> selectSplit(String sql, Object[] parameters, RowMapper<T> rowMapper) throws DataAccessException {
        PageSearch pageSearch = ListPageContext.getPageSearch();
        if (pageSearch != null) {
            return this.selectSplit(sql, parameters, pageSearch.getPageIndex(), pageSearch.getPageSize(), (T)rowMapper);
        }
        return this.selectSplit(sql, parameters, ListPageContext.getCurrentPageIndex(), ListPageContext.getCurrentPageSize(), (T)rowMapper);
    }

    @Override
    public MapPager selectSplit(String sql, Object[] parameters) throws DataAccessException {
        PageSearch pageSearch = ListPageContext.getPageSearch();
        if (pageSearch != null) {
            return this.selectSplit(sql, parameters, pageSearch.getPageIndex(), pageSearch.getPageSize());
        }
        return this.selectSplit(sql, parameters, ListPageContext.getCurrentPageIndex(), ListPageContext.getCurrentPageSize());
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(T po, String where, Map<String, Object> parameters) throws DataAccessException {
        PageSearch pageSearch = ListPageContext.getPageSearch();
        if (pageSearch != null) {
            return this.selectSplit(po, where, parameters, pageSearch.getPageIndex(), pageSearch.getPageSize());
        }
        return this.selectSplit(po, where, parameters, ListPageContext.getCurrentPageIndex(), ListPageContext.getCurrentPageSize());
    }

    @Override
    public int execute(String sql, Object[] parameters) throws DataAccessException {
        Assert.notNull((Object)sql, (String)"sql \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)parameters, (String)"parameters \u4e0d\u80fd\u4e3a\u7a7a!");
        this.printSql(new SqlAndParameters(sql, (Object)parameters));
        return this.jdbcTemplate.update(sql, parameters);
    }

    @Override
    public int execute(String sql, Map<String, Object> parameters) throws DataAccessException {
        Assert.notNull((Object)sql, (String)"sql \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull(parameters, (String)"parameters \u4e0d\u80fd\u4e3a\u7a7a!");
        this.printSql(new SqlAndParameters(sql, parameters));
        return this.namedParameterJdbcTemplate.update(sql, parameters);
    }

    @Override
    public int queryForInt(String sql, Object[] parameters) throws DataAccessException {
        Assert.notNull((Object)sql, (String)"sql \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)parameters, (String)"parameters \u4e0d\u80fd\u4e3a\u7a7a!");
        Integer res = this.queryForObject(sql, parameters, Integer.class);
        if (res == null) {
            throw new PersistenceException("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8f6c\u6362\u4e3aint");
        }
        return res;
    }

    @Override
    public int queryForInt(String sql, Map<String, Object> parameters) throws DataAccessException {
        Assert.notNull((Object)sql, (String)"sql \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull(parameters, (String)"parameters \u4e0d\u80fd\u4e3a\u7a7a!");
        Integer res = this.queryForObject(sql, parameters, Integer.class);
        if (res == null) {
            throw new PersistenceException("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8f6c\u6362\u4e3aint");
        }
        return res;
    }

    @Override
    public <T> T queryForObject(String sql, Object[] parameters, Class<T> clazz) throws DataAccessException {
        Assert.notNull((Object)sql, (String)"sql \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)parameters, (String)"parameters \u4e0d\u80fd\u4e3a\u7a7a!");
        List<SingleColumnRowMapper> list = this.select(sql, parameters, new SingleColumnRowMapper(clazz));
        return (T)this.getUnique(list);
    }

    private <T> T getUnique(List<T> list) {
        if (StringUtils.isEmptyList(list)) {
            return null;
        }
        if (list.size() > 1) {
            throw new PersistenceException("\u671f\u671b\u8fd4\u56de\u4e00\u6761\u8bb0\u5f55\uff0c\u5b9e\u9645\u8fd4\u56de " + list.size() + " \u6761\u8bb0\u5f55\uff01");
        }
        return list.get(0);
    }

    @Override
    public <T> T queryForObject(String sql, Map<String, Object> parameters, Class<T> clazz) throws DataAccessException {
        Assert.notNull((Object)sql, (String)"sql \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull(parameters, (String)"parameters \u4e0d\u80fd\u4e3a\u7a7a!");
        List<SingleColumnRowMapper> list = this.select(sql, parameters, new SingleColumnRowMapper(clazz));
        return (T)this.getUnique(list);
    }

    @Override
    public void execCall(final String functionName, final Object[] parameters) throws DataAccessException {
        Assert.notNull((Object)functionName, (String)"functionName \u4e0d\u80fd\u4e3a\u7a7a!");
        this.printSql(new SqlAndParameters(functionName, (Object)parameters));
        this.jdbcTemplate.execute(new CallableStatementCreator(){

            public CallableStatement createCallableStatement(Connection con) throws SQLException {
                CallableStatement cs = con.prepareCall(functionName);
                if (parameters != null) {
                    for (int i = 0; i < parameters.length; ++i) {
                        cs.setObject(i + 1, parameters[i]);
                    }
                }
                return cs;
            }
        }, new CallableStatementCallback(){

            public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                cs.execute();
                return null;
            }
        });
    }

    @Override
    public <T> T execCall(final String functionName, final Object[] parameters, final Class<T> clazz) throws DataAccessException {
        Assert.notNull((Object)functionName, (String)"functionName \u4e0d\u80fd\u4e3a\u7a7a!");
        this.printReturnCall(functionName, parameters);
        return (T)this.jdbcTemplate.execute(new CallableStatementCreator(){

            public CallableStatement createCallableStatement(Connection con) throws SQLException {
                CallableStatement cs = con.prepareCall(functionName);
                cs.registerOutParameter(1, -9);
                if (parameters != null) {
                    for (int i = 0; i < parameters.length; ++i) {
                        cs.setObject(i + 2, parameters[i]);
                    }
                }
                return cs;
            }
        }, new CallableStatementCallback<T>(){

            public T doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                cs.execute();
                cs.getResultSet();
                return JdbcDaoImpl.this.getStatementValue(cs, 1, clazz);
            }
        });
    }

    private void printReturnCall(String functionName, Object[] parameters) {
        if (this.isShowSql()) {
            ArrayList<String> ps = new ArrayList<String>();
            ps.add("?");
            if (parameters != null) {
                Collections.addAll(ps, parameters);
            }
            Matcher matcher = ARRAY_PARAMETER_PLACEHOLDER.matcher(functionName);
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (matcher.find()) {
                matcher.appendReplacement(sb, this.getSqlParamValue(ps.get(i++)));
            }
            matcher.appendTail(sb);
            this.logger.info("{}", (Object)sb);
        }
    }

    private String getSqlParamValue(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String || value instanceof java.util.Date) {
            return "'" + StringSqlUtils.escapeSql((String)value.toString()) + "'";
        }
        return value.toString();
    }

    private Object getStatementValue(CallableStatement cs, int index, Class<?> requiredType) throws SQLException {
        Comparable<Boolean> value;
        if (String.class == requiredType) {
            return cs.getString(index);
        }
        if (Boolean.TYPE == requiredType || Boolean.class == requiredType) {
            value = cs.getBoolean(index);
        } else if (Byte.TYPE == requiredType || Byte.class == requiredType) {
            value = cs.getByte(index);
        } else if (Short.TYPE == requiredType || Short.class == requiredType) {
            value = cs.getShort(index);
        } else if (Integer.TYPE == requiredType || Integer.class == requiredType) {
            value = cs.getInt(index);
        } else if (Long.TYPE == requiredType || Long.class == requiredType) {
            value = cs.getLong(index);
        } else if (Float.TYPE == requiredType || Float.class == requiredType) {
            value = Float.valueOf(cs.getFloat(index));
        } else if (Double.TYPE == requiredType || Double.class == requiredType || Number.class == requiredType) {
            value = cs.getDouble(index);
        } else {
            if (BigDecimal.class == requiredType) {
                return cs.getBigDecimal(index);
            }
            if (Date.class == requiredType) {
                return cs.getDate(index);
            }
            if (Time.class == requiredType) {
                return cs.getTime(index);
            }
            if (Timestamp.class == requiredType || java.util.Date.class == requiredType) {
                return cs.getTimestamp(index);
            }
            if (byte[].class == requiredType) {
                return cs.getBytes(index);
            }
            if (Blob.class == requiredType) {
                return cs.getBlob(index);
            }
            if (Clob.class == requiredType) {
                return cs.getClob(index);
            }
            throw new PersistenceException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b" + requiredType + "\uff01");
        }
        return value;
    }

    @Override
    public int execBatchUpdate(String sql, List<?> parametersList) throws DataAccessException {
        int[] temp;
        Assert.notNull((Object)sql, (String)"sql\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull(parametersList, (String)"parametersList\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (parametersList.size() == 0) {
            throw new PersistenceException("parametersList\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (parametersList.get(0) instanceof Map) {
            Map[] params = parametersList.toArray(new Map[parametersList.size()]);
            temp = this.namedParameterJdbcTemplate.batchUpdate(sql, params);
        } else if (parametersList.get(0).getClass().isArray()) {
            temp = this.jdbcTemplate.batchUpdate(sql, parametersList);
        } else {
            throw new PersistenceException("parametersList\u5185\u5bb9\u7c7b\u578b\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
        }
        int result = 0;
        if (temp != null) {
            for (int v : temp) {
                result += v;
            }
        }
        return result;
    }

    @Override
    public void update(String sql) {
    }

    @Override
    public int update(String sql, Object[] args) {
        return 0;
    }

    @Override
    public <T> List<T> sqlQuery(String sql, RowMapper<T> rowMapper) {
        return null;
    }

    @Override
    public <T> List<T> sqlQuery(String sql, Object[] args, RowMapper<T> rowMapper) {
        return null;
    }

    @Override
    public List<Map<String, Object>> sqlQueryListMap(String sql, Object[] args) {
        return null;
    }

    @Override
    public <E> GenericPager<E> sqlGeneralQueryPager(String sql, Object[] args, RowMapper<E> rowMapper) {
        return null;
    }

    @Override
    public <E> GenericPager<E> sqlGeneralQueryPager(String sql, Object[] args, RowMapper<E> rowMapper, int pageIndex) {
        return null;
    }

    @Override
    public <T> GenericPager<T> sqlGeneralQueryPager(String sql, Object[] args, RowMapper<T> rowMapper, int pageIndex, int pageSize) {
        return null;
    }

    @Override
    public <T> T sqlMathQuery(String sql, Object[] args, Class<T> clazz) {
        return null;
    }

    @Override
    public <T> List<T> sqlListObjectWhereIn(String sql, RowMapper<T> rowMapper, SqlParameterSource paramSource) {
        return null;
    }

    @Override
    public List<Map<String, Object>> queryListObjectWhereIn(String sql, SqlParameterSource paramSource) {
        return null;
    }

    @Override
    public <T> void execute(final String sql, final Object[] parameters, final RowMapper<T> rowMapper, final BaseDao.RowExecution<T> rowExecution) {
        this.jdbcTemplate.execute(sql, new PreparedStatementCallback<T>(){

            public T doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                ps.setFetchSize(512);
                if (parameters != null) {
                    for (int i = 0; i < parameters.length; ++i) {
                        ps.setObject(i + 1, parameters[i]);
                    }
                }
                JdbcDaoImpl.this.printSql(new SqlAndParameters(sql, (Object)parameters));
                ResultSet rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        Object t = rowMapper.mapRow(rs, 1);
                        rowExecution.execute(t);
                    }
                }
                catch (Exception e) {
                    throw new PersistenceException(e);
                }
                finally {
                    org.springframework.jdbc.support.JdbcUtils.closeResultSet((ResultSet)rs);
                }
                return null;
            }
        });
    }

    @Override
    public <T extends BasePo<T>> void execute(String sql, Object[] parameters, T po, BaseDao.RowExecution<T> rowExecution) {
        this.execute(sql, parameters, (T)this.convertToMapper(po), rowExecution);
    }
}

