/*
 * Decompiled with CFR 0.152.
 */
package com.walker.jdbc.dao;

import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.db.page.PageSearch;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.dao.JdbcDaoImpl;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class SqlDaoSupport
extends JdbcDaoImpl {
    protected static final String SELECT_COUNT = "select count(*) as dby_num ";
    protected static final String SELECT_COUNT_1 = "from (";
    protected static final String SELECT_COUNT_2 = ") as dby_temp";
    protected static final String SELECT_COUNT_3 = ")";
    protected static final String SQL_FROM = " from";
    public static final String SQL_ORDERBY = "order by";

    @Override
    public void update(String sql) {
        assert (StringUtils.isNotEmpty((String)sql));
        this.getJdbcTemplate().update(sql);
    }

    @Override
    public int update(String sql, Object[] args) {
        assert (StringUtils.isNotEmpty((String)sql));
        return this.getJdbcTemplate().update(sql, args);
    }

    @Override
    public <T> List<T> sqlQuery(String sql, RowMapper<T> rowMapper) {
        return this.sqlQuery(sql, null, rowMapper);
    }

    @Override
    public <T> List<T> sqlQuery(String sql, Object[] args, RowMapper<T> rowMapper) {
        assert (StringUtils.isNotEmpty((String)sql));
        assert (rowMapper != null);
        return this.getJdbcTemplate().query(sql, rowMapper, args);
    }

    @Override
    public List<Map<String, Object>> sqlQueryListMap(String sql, Object[] args) {
        return this.getJdbcTemplate().queryForList(sql, args);
    }

    @Override
    public <E> GenericPager<E> sqlGeneralQueryPager(String sql, Object[] args, RowMapper<E> rowMapper) {
        PageSearch pageSearch = ListPageContext.getPageSearch();
        if (pageSearch != null) {
            return this.sqlGeneralQueryPager(sql, args, rowMapper, pageSearch.getPageIndex(), pageSearch.getPageSize());
        }
        return this.sqlGeneralQueryPager(sql, args, rowMapper, ListPageContext.getCurrentPageIndex(), ListPageContext.getCurrentPageSize());
    }

    @Override
    public <E> GenericPager<E> sqlGeneralQueryPager(String sql, Object[] args, RowMapper<E> rowMapper, int pageIndex) {
        PageSearch pageSearch = ListPageContext.getPageSearch();
        if (pageSearch != null) {
            return this.sqlGeneralQueryPager(sql, args, rowMapper, pageIndex, pageSearch.getPageSize());
        }
        return this.sqlGeneralQueryPager(sql, args, rowMapper, pageIndex, ListPageContext.getCurrentPageSize());
    }

    @Override
    public <T> GenericPager<T> sqlGeneralQueryPager(String sql, Object[] args, RowMapper<T> rowMapper, int pageIndex, int pageSize) {
        int count = 0;
        Integer countObj = (Integer)this.getJdbcTemplate().queryForObject(this.getJdbcCountQuery(sql, this.getPaginationHelper().getType()), Integer.class, args);
        if (countObj != null) {
            count = countObj;
        }
        GenericPager pager = ListPageContext.createGenericPager((int)pageIndex, (int)pageSize, (int)count);
        String querySql = this.getPaginationHelper().getSqlPagingQuery(sql, null);
        this.logger.debug("......jdbc\u5206\u9875sql: " + querySql);
        List datas = this.getJdbcTemplate().query(querySql, rowMapper, this.getSqlPageArgs(args, (int)pager.getFirstRowIndexInPage(), pageSize, this.getPaginationHelper().getType()));
        return pager.setDatas(datas);
    }

    @Override
    public <T> T sqlMathQuery(String sql, Object[] args, Class<T> clazz) {
        return (T)this.getJdbcTemplate().queryForObject(sql, clazz, args);
    }

    @Override
    public <T> List<T> sqlListObjectWhereIn(String sql, RowMapper<T> rowMapper, SqlParameterSource paramSource) {
        return this.getNamedParameterJdbcTemplate().query(sql, paramSource, rowMapper);
    }

    @Override
    public List<Map<String, Object>> queryListObjectWhereIn(String sql, SqlParameterSource paramSource) {
        return this.getNamedParameterJdbcTemplate().queryForList(sql, paramSource);
    }

    protected Object[] getSqlPageArgs(Object[] args, int firstRowIndex, int pageSize, String type) {
        Object[] params = null;
        if (type.equals("sqlserver")) {
            if (firstRowIndex == 0) {
                if (args != null && args.length != 0) {
                    params = args;
                }
            } else if (args == null || args.length == 0) {
                params = new Object[]{firstRowIndex, firstRowIndex + pageSize};
            } else {
                params = new Object[args.length + 2];
                for (j = 0; j < args.length + 1; ++j) {
                    params[j] = args[j - 1];
                }
                params[j] = firstRowIndex;
                params[j + 1] = firstRowIndex + pageSize;
            }
        } else if (args == null || args.length == 0) {
            params = new Object[2];
        } else {
            params = new Object[args.length + 2];
            while (j < args.length) {
                params[j] = args[j];
                ++j;
            }
        }
        if (type.equals("mysql") || type.equals("derby")) {
            params[j] = firstRowIndex;
            params[j + 1] = pageSize;
        } else if (type.equals("oracle")) {
            params[j] = firstRowIndex + pageSize;
            params[j + 1] = firstRowIndex;
        } else if (type.equals("postgres")) {
            params[j] = pageSize;
            params[j + 1] = firstRowIndex;
        } else if (type.equals("sqlserver")) {
            // empty if block
        }
        return params;
    }

    protected String getJdbcCountQuery(String sql, String type) {
        if (StringUtils.isEmpty((String)sql)) {
            throw new RuntimeException("sql is required!");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(SELECT_COUNT).append(SELECT_COUNT_1);
        if (type.equals("sqlserver")) {
            int index = sql.toLowerCase().indexOf(SQL_ORDERBY);
            if (index > 0) {
                sb.append(sql.substring(0, index));
            } else {
                sb.append(sql);
            }
        } else {
            sb.append(sql);
        }
        if (type.equals("oracle") || type.equals("dm")) {
            sb.append(SELECT_COUNT_3);
        } else {
            sb.append(SELECT_COUNT_2);
        }
        return sb.toString();
    }

    public void batchUpdate(String sql) {
        this.batchUpdate(sql, null);
    }

    public void batchUpdate(String sql, final List<Object[]> parameters) {
        this.getJdbcTemplate().batchUpdate(sql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                if (parameters == null) {
                    return;
                }
                Object[] param = (Object[])parameters.get(i);
                if (param == null || param.length == 0) {
                    return;
                }
                int _psize = param.length;
                Object _p = null;
                Class<?> _pc = null;
                for (int j = 1; j < _psize + 1; ++j) {
                    _p = param[j - 1];
                    if (_p == null) {
                        throw new IllegalArgumentException("parameter in arrays can't be null!");
                    }
                    _pc = _p.getClass();
                    if (_pc.isPrimitive()) {
                        if (_pc == Integer.TYPE) {
                            ps.setInt(j, (Integer)_p);
                            continue;
                        }
                        if (_pc == Float.TYPE) {
                            ps.setFloat(j, ((Float)_p).floatValue());
                            continue;
                        }
                        if (_pc == Boolean.TYPE) {
                            ps.setBoolean(j, (Boolean)_p);
                            continue;
                        }
                        if (_pc == Long.TYPE) {
                            ps.setLong(j, (Long)_p);
                            continue;
                        }
                        if (_pc != Double.TYPE) continue;
                        ps.setDouble(j, (Double)_p);
                        continue;
                    }
                    if (_pc == String.class) {
                        ps.setString(j, _p.toString());
                        continue;
                    }
                    if (_pc == Integer.class) {
                        ps.setInt(j, (Integer)_p);
                        continue;
                    }
                    if (_pc == Float.class) {
                        ps.setFloat(j, ((Float)_p).floatValue());
                        continue;
                    }
                    if (_pc == Boolean.class) {
                        ps.setBoolean(j, (Boolean)_p);
                        continue;
                    }
                    if (_pc == Long.class) {
                        ps.setLong(j, (Long)_p);
                        continue;
                    }
                    if (_pc == Double.class) {
                        ps.setDouble(j, (Double)_p);
                        continue;
                    }
                    ps.setObject(j, _p);
                }
            }

            public int getBatchSize() {
                if (parameters == null) {
                    return 0;
                }
                return parameters.size();
            }
        });
    }

    protected Object[] getSearchConditionParams(Object[] temp) {
        if (temp == null || ((Object[])temp).length == 0) {
            return null;
        }
        ArrayList<Object> params = new ArrayList<Object>(((Object[])temp).length);
        for (Object _p : temp) {
            if (_p == null) continue;
            params.add(_p);
        }
        temp = params.size() > 0 ? params.toArray() : null;
        return temp;
    }
}

