/*
 * Decompiled with CFR 0.152.
 */
package com.walker.jdbc.dao;

import com.walker.db.Sorts;
import com.walker.db.page.GenericPager;
import com.walker.jdbc.SqlAndParameters;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class PaginationHelper {
    private String type;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOrderBySql(String sql, Sorts.Sort sort) {
        if (sort == null) {
            return sql;
        }
        return sql + " order by " + sort.getField() + " " + sort.getValue();
    }

    public String getSqlPagingQuery(String sql, Sorts.Sort sort) {
        sql = this.getOrderBySql(sql, sort);
        if ("oracle".equalsIgnoreCase(this.type) || "dm".equalsIgnoreCase(this.type)) {
            return "select * from (select row_.*, rownum rownum_ from (" + sql + ") row_ where rownum <= ?) where rownum_ >= ?";
        }
        if ("mysql".equalsIgnoreCase(this.type) || "sqlite".equalsIgnoreCase(this.type)) {
            return sql + " limit ?, ?";
        }
        if ("postgres".equalsIgnoreCase(this.type)) {
            return sql + " limit ? offset ?";
        }
        return sql + " limit ?, ?";
    }

    public SqlAndParameters<Map<String, Object>> getSqlPagingQuery(String sql, Map<String, Object> parameters, GenericPager<?> pager, Sorts.Sort sort) {
        sql = this.getOrderBySql(sql, sort);
        HashMap<String, Object> temp = new HashMap<String, Object>(4);
        temp.putAll(parameters);
        String pageSql = null;
        if ("oracle".equalsIgnoreCase(this.type) || "dm".equalsIgnoreCase(this.type)) {
            if (pager.getPageIndex() == 1) {
                pageSql = "select row_.*, rownum rownum_ from (" + sql + ") row_ where rownum <= :endRow_";
                temp.put("endRow_", pager.getEndRowIndexPage() + 1L);
            } else {
                pageSql = "select * from (select row_.*, rownum rownum_ from (" + sql + ") row_ where rownum <= :endRow_) where rownum_ >= :startRow_";
                temp.put("startRow_", pager.getFirstRowIndexInPage() + 1L);
                temp.put("endRow_", pager.getEndRowIndexPage() + 1L);
            }
        } else if ("mysql".equalsIgnoreCase(this.type) || "sqlite".equalsIgnoreCase(this.type)) {
            if (pager.getPageIndex() == 1) {
                pageSql = sql + " limit :pageSize_";
                temp.put("pageSize_", pager.getPageSize());
            } else {
                pageSql = sql + " limit :startRow_, :pageSize_";
                temp.put("startRow_", pager.getFirstRowIndexInPage());
                temp.put("pageSize_", pager.getPageSize());
            }
        } else if ("postgres".equalsIgnoreCase(this.type)) {
            if (pager.getPageIndex() == 1) {
                pageSql = sql + " limit :pageSize_";
                temp.put("pageSize_", pager.getPageSize());
            } else {
                pageSql = sql + " limit :pageSize_ offset :startRow_";
                temp.put("pageSize_", pager.getPageSize());
                temp.put("startRow_", pager.getFirstRowIndexInPage());
            }
        } else {
            System.out.println("type = " + this.type);
            if (pager.getPageIndex() == 1) {
                pageSql = sql + " limit :pageSize_";
                temp.put("pageSize_", pager.getPageSize());
            } else {
                pageSql = sql + " limit :startRow_, :pageSize_";
                temp.put("startRow_", pager.getFirstRowIndexInPage());
                temp.put("pageSize_", pager.getPageSize());
            }
        }
        return new SqlAndParameters(pageSql, temp);
    }

    public SqlAndParameters<Object[]> getSqlPagingQuery(String sql, Object[] parameters, GenericPager<?> pager, Sorts.Sort sort) {
        sql = this.getOrderBySql(sql, sort);
        Object[] tempArray = null;
        String pageSql = null;
        if ("oracle".equalsIgnoreCase(this.type) || "dm".equalsIgnoreCase(this.type)) {
            if (pager.getPageIndex() == 1) {
                pageSql = "select row_.*, rownum rownum_ from (" + sql + ") row_ where rownum <= ?";
                tempArray = ArrayUtils.add((Object[])parameters, (Object)(pager.getEndRowIndexPage() + 1L));
            } else {
                pageSql = "select * from (select row_.*, rownum rownum_ from (" + sql + ") row_ where rownum <= ?) where rownum_ >= ?";
                tempArray = ArrayUtils.add((Object[])parameters, (Object)(pager.getEndRowIndexPage() + 1L));
                tempArray = ArrayUtils.add((Object[])tempArray, (Object)(pager.getFirstRowIndexInPage() + 1L));
            }
        } else if ("mysql".equalsIgnoreCase(this.type) || "sqlite".equalsIgnoreCase(this.type)) {
            if (pager.getPageIndex() == 1) {
                pageSql = sql + " limit ?";
                tempArray = ArrayUtils.add((Object[])parameters, (Object)pager.getPageSize());
            } else {
                pageSql = sql + " limit ?, ?";
                tempArray = ArrayUtils.add((Object[])parameters, (Object)pager.getFirstRowIndexInPage());
                tempArray = ArrayUtils.add((Object[])tempArray, (Object)pager.getPageSize());
            }
        } else if ("postgres".equalsIgnoreCase(this.type)) {
            if (pager.getPageIndex() == 1) {
                pageSql = sql + " limit ?";
                tempArray = ArrayUtils.add((Object[])parameters, (Object)pager.getPageSize());
            } else {
                pageSql = sql + " limit ? offset ?";
                tempArray = ArrayUtils.add((Object[])parameters, (Object)pager.getPageSize());
                tempArray = ArrayUtils.add((Object[])tempArray, (Object)pager.getFirstRowIndexInPage());
            }
        } else {
            System.out.println("getSqlPagingQuery,\u4e0d\u652f\u6301\u7684\u5206\u9875\u7c7b\u578b:" + this.type);
            if (pager.getPageIndex() == 1) {
                pageSql = sql + " limit ?";
                tempArray = ArrayUtils.add((Object[])parameters, (Object)pager.getPageSize());
            } else {
                pageSql = sql + " limit ?,?";
                tempArray = ArrayUtils.add((Object[])parameters, (Object)pager.getFirstRowIndexInPage());
                tempArray = ArrayUtils.add((Object[])tempArray, (Object)pager.getPageSize());
            }
        }
        return new SqlAndParameters(pageSql, (Object)tempArray);
    }
}

