/*
 * Decompiled with CFR 0.152.
 */
package com.walker.jdbc.ds;

import com.walker.db.DatabaseType;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.Constants;
import com.walker.jdbc.DataSourceMeta;
import com.walker.jdbc.util.TextUtils;
import com.zaxxer.hikari.HikariDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataSource
extends HikariDataSource
implements DataSourceMeta {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private DatabaseType databaseType = null;
    private String username;
    private String password;
    private String databaseName;
    protected String ip;
    protected int port = 0;

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Override
    public String getUrl() {
        return this.getJdbcUrl();
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setJdbcUrl(String jdbcUrl) {
        String[] values;
        super.setJdbcUrl(jdbcUrl);
        this.logger.info("jdbcUrl = " + jdbcUrl);
        String[] ipAndPortAndService = TextUtils.parseIpAndPortFromUrl(jdbcUrl);
        if (ipAndPortAndService != null) {
            this.ip = ipAndPortAndService[0];
            this.port = Integer.parseInt(ipAndPortAndService[1]);
            this.databaseName = ipAndPortAndService[2];
        }
        if ((values = jdbcUrl.split(":")) == null || values.length <= 1) {
            throw new ApplicationRuntimeException("DataSource set jdbcUrl error: " + jdbcUrl);
        }
        for (String v : values) {
            if (v.equalsIgnoreCase("mysql")) {
                this.databaseType = DatabaseType.MYSQL;
                return;
            }
            if (v.equalsIgnoreCase("oracle")) {
                this.databaseType = DatabaseType.ORACLE;
                return;
            }
            if (v.equalsIgnoreCase("postgres")) {
                this.databaseType = DatabaseType.POSTGRES;
                return;
            }
            if (v.equalsIgnoreCase("sqlite")) {
                this.databaseType = DatabaseType.SQLITE;
                return;
            }
            if (!v.equalsIgnoreCase("dm")) continue;
            this.databaseType = DatabaseType.DAMENG;
            return;
        }
        if (this.databaseType == null) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93URL\u53c2\u6570\uff1a" + jdbcUrl);
        }
        this.logger.info("\u6570\u636e\u5e93\u7c7b\u578b\uff1a" + this.databaseType.name());
    }

    public void setDriverClassName(String driverClassName) {
        super.setDriverClassName(driverClassName);
        this.logger.debug("driverClassName = " + driverClassName);
    }

    public void setDatabaseType(int databaseTypeValue) {
        this.databaseType = DatabaseType.getType((int)databaseTypeValue);
        String driverName = Constants.getDriverClassName(this.databaseType);
        try {
            this.setDriverClassName(driverName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u8be5\u9a71\u52a8\uff1a" + driverName, e);
        }
    }

    public void setIp(String ip) {
        assert (StringUtils.isNotEmpty((String)ip));
        this.ip = ip;
    }

    public void setPort(int port) {
        assert (port > 0 && port < Integer.MAX_VALUE);
        this.port = port;
    }

    public void setDatabaseName(String databaseName) {
        if (this.databaseType == null) {
            throw new IllegalArgumentException("databaseType must be set firstly!");
        }
        if (this.databaseType != DatabaseType.DERBY && StringUtils.isEmpty((String)this.ip)) {
            throw new IllegalArgumentException("ip or port must be set firstly!");
        }
        assert (StringUtils.isNotEmpty((String)databaseName));
        String url = Constants.getJdbcUrl(this.databaseType, databaseName, this.ip, this.port);
        this.setJdbcUrl(url);
    }
}

