/*
 * Decompiled with CFR 0.152.
 */
package com.walker.jdbc.ds;

import com.alibaba.druid.pool.DruidDataSource;
import com.walker.db.DatabaseType;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.SegmentReader;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.Constants;
import com.walker.jdbc.DataSourceMeta;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresqlClusterDataSource
extends DruidDataSource
implements DataSourceMeta {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private DatabaseType databaseType = null;
    private String username;
    private String password;
    private String databaseName;
    private String jdbcUrl;
    protected String ip;
    protected int port = 0;

    @Override
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getUrl() {
        return this.jdbcUrl;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    public void setUrl(String jdbcUrl) {
        String[] values;
        this.jdbcUrl = jdbcUrl;
        super.setUrl(jdbcUrl);
        this.logger.info("jdbcUrl = " + jdbcUrl);
        String[] ipAndPort = this.acquireIpAndPort(jdbcUrl);
        if (ipAndPort != null) {
            this.ip = ipAndPort[0];
            this.port = Integer.parseInt(ipAndPort[1]);
            this.databaseName = this.acquireDatabaseName(jdbcUrl);
        }
        if ((values = jdbcUrl.split(":")) == null || values.length <= 1) {
            throw new ApplicationRuntimeException("DataSource set jdbcUrl error: " + jdbcUrl);
        }
        for (String v : values) {
            if (v.equalsIgnoreCase("mysql")) {
                this.databaseType = DatabaseType.MYSQL;
                return;
            }
            if (v.equalsIgnoreCase("oracle")) {
                this.databaseType = DatabaseType.ORACLE;
                return;
            }
            if (v.equalsIgnoreCase("postgres") || v.equalsIgnoreCase("postgresql")) {
                this.databaseType = DatabaseType.POSTGRES;
                return;
            }
            if (v.equalsIgnoreCase("sqlite")) {
                this.databaseType = DatabaseType.SQLITE;
                return;
            }
            if (!v.equalsIgnoreCase("dm")) continue;
            this.databaseType = DatabaseType.DAMENG;
            return;
        }
        if (this.databaseType == null) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93URL\u53c2\u6570\uff1a" + jdbcUrl);
        }
        this.logger.info("\u6570\u636e\u5e93\u7c7b\u578b\uff1a" + this.databaseType.name());
    }

    protected String[] acquireIpAndPort(String jdbcUrl) {
        SegmentReader reader = new SegmentReader();
        reader.setKeyCaseSensitive(false);
        reader.addKey("//", "/");
        this.logger.info(reader.read(jdbcUrl));
        List paramList = reader.getSolvedList("//", "/");
        if (StringUtils.isEmptyList((List)paramList)) {
            throw new ApplicationRuntimeException("druid\u8bbe\u7f6e\u7684url\u4e2d\u672a\u5305\u542b\u4efb\u4f55\u6570\u636e\u5e93ip\u4fe1\u606f\uff1a" + jdbcUrl, null);
        }
        String ipPort = ((StringBuilder)paramList.get(0)).toString().split(",")[0];
        return ipPort.split(":");
    }

    protected String acquireDatabaseName(String jdbcUrl) {
        SegmentReader reader2 = new SegmentReader();
        reader2.setKeyCaseSensitive(false);
        reader2.addKey("/", "?");
        this.logger.info(reader2.read(jdbcUrl));
        List paramList = reader2.getSolvedList("/", "?");
        if (StringUtils.isEmptyList((List)paramList)) {
            throw new ApplicationRuntimeException("druid\u8bbe\u7f6e\u7684url\u4e2d\u672a\u5305\u542b\u4efb\u4f55\u6570\u636e\u5e93\u540d\u79f0\u4fe1\u606f\uff1a" + jdbcUrl, null);
        }
        return ((StringBuilder)paramList.get(0)).toString();
    }

    public void setDriverClassName(String driverClassName) {
        super.setDriverClassName(driverClassName);
        this.logger.debug("driverClassName = " + driverClassName);
    }

    @Deprecated
    public void setIp(String ip) {
        assert (StringUtils.isNotEmpty((String)ip));
        this.ip = ip;
    }

    @Deprecated
    public void setPort(int port) {
        assert (port > 0 && port < Integer.MAX_VALUE);
        this.port = port;
    }

    public void setJdbcUrl(String jdbcUrl) {
        if (StringUtils.isEmpty((String)this.jdbcUrl)) {
            this.jdbcUrl = jdbcUrl;
        } else {
            this.logger.warn("jdbcUrl\u5df2\u7ecf\u5b58\u5728\uff0c\u65e0\u9700\u91cd\u590d\u8bbe\u7f6e! \u5f53\u524durl={}, \u8981\u8bbe\u7f6e\u7684url={}", (Object)this.jdbcUrl, (Object)jdbcUrl);
        }
    }

    public void setDatabaseType(int databaseTypeValue) {
        this.databaseType = DatabaseType.getType((int)databaseTypeValue);
        String driverName = Constants.getDriverClassName(this.databaseType);
        this.setDriverClassName(driverName);
    }

    public void setDatabaseName(String databaseName) {
        if (StringUtils.isEmpty((String)databaseName)) {
            throw new IllegalArgumentException("databaseName \u5fc5\u987b\u586b\u5199!");
        }
        if (this.databaseType == null) {
            throw new IllegalArgumentException("databaseType must be set firstly!");
        }
        if (this.databaseType != DatabaseType.DERBY && StringUtils.isEmpty((String)this.ip)) {
            throw new IllegalArgumentException("ip or port must be set firstly!");
        }
        this.setUrl(this.jdbcUrl);
    }
}

