/*
 * Decompiled with CFR 0.152.
 */
package com.walker.jdbc.service;

import com.walker.common.util.ConvertUtil;
import com.walker.common.util.MapBuilder;
import com.walker.db.Sorts;
import com.walker.db.page.GenericPager;
import com.walker.db.page.MapPager;
import com.walker.jdbc.BaseDao;
import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.BasePo;
import com.walker.jdbc.service.BaseService;
import com.walker.jdbc.util.JdbcUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class BaseServiceImpl
implements BaseService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="dao")
    protected BaseDao dao;

    private <T extends BasePo<T>> BaseMapper<T> convertToMapper(T basePo) {
        return JdbcUtils.getInstance(basePo);
    }

    @Override
    public <T extends BasePo<T>> int save(T po) {
        return this.dao.save(po);
    }

    @Override
    public <T extends BasePo<T>> int save(List<T> listPo) {
        int sum = 0;
        for (BasePo po : listPo) {
            sum += this.save(po);
        }
        return sum;
    }

    protected BaseDao getDao() {
        return this.dao;
    }

    public void setDao(BaseDao dao) {
        this.dao = dao;
    }

    @Override
    public <T extends BasePo<T>> int insert(T po) throws DataAccessException {
        return this.dao.insert(po);
    }

    @Override
    public <T extends BasePo<T>> int insert(List<T> poList) throws DataAccessException {
        return this.dao.insert(poList);
    }

    @Override
    public <T extends BasePo<T>> int insertBatch(List<T> poList) throws DataAccessException {
        return this.dao.insertBatch(poList);
    }

    @Override
    public <T extends BasePo<T>> int update(T po) throws DataAccessException {
        return this.dao.update(po);
    }

    @Override
    public <T extends BasePo<T>> int update(List<T> poList) throws DataAccessException {
        return this.dao.update(poList);
    }

    @Override
    public <T extends BasePo<T>> int updateBatch(List<T> poList) throws DataAccessException {
        return this.dao.updateBatch(poList);
    }

    @Override
    public <T extends BasePo<T>> int update(T po, String where, Map<String, Object> parameters) throws DataAccessException {
        return this.dao.update(po, where, parameters);
    }

    @Override
    public <T extends BasePo<T>> int update(T po, String where, Object[] parameters) throws DataAccessException {
        return this.dao.update(po, where, parameters);
    }

    @Override
    public <T extends BasePo<T>> int delete(T po) throws DataAccessException {
        return this.dao.delete(po);
    }

    @Override
    public <T extends BasePo<T>> int delete(List<T> poList) throws DataAccessException {
        return this.dao.delete(poList);
    }

    @Override
    public <T extends BasePo<T>> int delete(T po, String where, Map<String, Object> parameters) throws DataAccessException {
        return this.dao.delete(po, where, parameters);
    }

    @Override
    public <T extends BasePo<T>> int delete(T po, String where, Object[] parameters) throws DataAccessException {
        return this.dao.delete(po, where, parameters);
    }

    @Override
    public <T extends BasePo<T>> T get(T po) throws DataAccessException {
        return this.dao.get(po);
    }

    @Override
    public <T extends BasePo<T>> T get(T po, String where, Map<String, Object> parameters) throws DataAccessException {
        return this.dao.get(po, where, parameters);
    }

    @Override
    public <T extends BasePo<T>> T get(T po, String where, Object[] parameters) throws DataAccessException {
        return this.dao.get(po, where, parameters);
    }

    @Override
    public <T> T get(String sql, Map<String, Object> parameters, RowMapper<T> rowMapper) throws DataAccessException {
        return (T)this.dao.get(sql, parameters, rowMapper);
    }

    @Override
    public <T extends BasePo<T>> T get(String sql, Map<String, Object> parameters, T po) throws DataAccessException {
        return this.dao.get(sql, parameters, po);
    }

    @Override
    public <T> T get(String sql, Object[] parameters, RowMapper<T> rowMapper) throws DataAccessException {
        return (T)this.dao.get(sql, parameters, rowMapper);
    }

    @Override
    public <T extends BasePo<T>> T get(String sql, Object[] parameters, T po) throws DataAccessException {
        return this.dao.get(sql, parameters, po);
    }

    @Override
    public Map<String, Object> get(String sql, Map<String, Object> parameters) throws DataAccessException {
        return this.dao.get(sql, parameters);
    }

    @Override
    public Map<String, Object> get(String sql, Object[] parameters) throws DataAccessException {
        return this.dao.get(sql, parameters);
    }

    @Override
    public <T extends BasePo<T>> List<T> select(T po, String where, Map<String, Object> parameters) throws DataAccessException {
        return this.dao.select(po, where, parameters);
    }

    @Override
    public <T extends BasePo<T>> List<T> select(T po, String where, Object[] parameters) throws DataAccessException {
        return this.dao.select(po, where, parameters);
    }

    @Override
    public <T extends BasePo<T>> List<T> select(T po) throws DataAccessException {
        return this.dao.select(po);
    }

    @Override
    public <T extends BasePo<T>> List<T> select(T po, Sorts.Sort sort) throws DataAccessException {
        return this.dao.select(po, sort);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(T po, String where, Map<String, Object> parameters, int currentPage, int pageSize) throws DataAccessException {
        return this.dao.selectSplit(po, where, parameters, currentPage, pageSize);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(T po, int currentPage, int pageSize) throws DataAccessException {
        return this.dao.selectSplit(po, currentPage, pageSize);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(T po, int currentPage, int pageSize, Sorts.Sort sort) throws DataAccessException {
        return this.dao.selectSplit(po, currentPage, pageSize, sort);
    }

    @Override
    public List<Map<String, Object>> select(String sql, Object[] parameters) throws DataAccessException {
        return this.dao.select(sql, parameters);
    }

    @Override
    public <T> List<T> select(String sql, Object[] parameters, RowMapper<T> mapper) throws DataAccessException {
        return this.dao.select(sql, parameters, mapper);
    }

    @Override
    public <T extends BasePo<T>> List<T> select(String sql, Object[] parameters, T po) throws DataAccessException {
        return this.dao.select(sql, parameters, po);
    }

    @Override
    public MapPager selectSplit(String sql, Object[] parameters, int currentPage, int pageSize) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, currentPage, pageSize);
    }

    @Override
    public MapPager selectSplit(String sql, Object[] parameters, int currentPage, int pageSize, Sorts.Sort sort) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, currentPage, pageSize, sort);
    }

    @Override
    public <T> GenericPager<T> selectSplit(String sql, Object[] parameters, int currentPage, int pageSize, RowMapper<T> rowMapper) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, currentPage, pageSize, rowMapper);
    }

    @Override
    public <T> GenericPager<T> selectSplit(String sql, Object[] parameters, int currentPage, int pageSize, RowMapper<T> rowMapper, Sorts.Sort sort) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, currentPage, pageSize, rowMapper, sort);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(String sql, Object[] parameters, int currentPage, int pageSize, T po) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, currentPage, pageSize, po);
    }

    @Override
    public List<Map<String, Object>> select(String sql, Map<String, Object> parameters) throws DataAccessException {
        return this.dao.select(sql, parameters);
    }

    @Override
    public <T> List<T> select(String sql, Map<String, Object> parameters, RowMapper<T> mapper) throws DataAccessException {
        return this.dao.select(sql, parameters, mapper);
    }

    @Override
    public <T extends BasePo<T>> List<T> select(String sql, Map<String, Object> parameters, T po) throws DataAccessException {
        return this.dao.select(sql, parameters, po);
    }

    @Override
    public MapPager selectSplit(String sql, Map<String, Object> parameters, int currentPage, int pageSize) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, currentPage, pageSize);
    }

    @Override
    public MapPager selectSplit(String sql, Map<String, Object> parameters, int currentPage, int pageSize, Sorts.Sort sort) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, currentPage, pageSize, sort);
    }

    @Override
    public <T> GenericPager<T> selectSplit(String sql, Map<String, Object> parameters, int currentPage, int pageSize, RowMapper<T> rowMapper) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, currentPage, pageSize, rowMapper);
    }

    @Override
    public <T> GenericPager<T> selectSplit(String sql, Map<String, Object> parameters, int currentPage, int pageSize, RowMapper<T> rowMapper, Sorts.Sort sort) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, currentPage, pageSize, rowMapper, sort);
    }

    @Override
    public <T> GenericPager<T> selectSplit(String sql, Map<String, Object> parameters, RowMapper<T> rowMapper, Sorts.Sort sort) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, rowMapper, sort);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(String sql, Map<String, Object> parameters, int currentPage, int pageSize, T po) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, currentPage, pageSize, po);
    }

    @Override
    public int execute(String sql, Object[] parameters) throws DataAccessException {
        return this.dao.execute(sql, parameters);
    }

    @Override
    public int execute(String sql, Map<String, Object> parameters) throws DataAccessException {
        return this.dao.execute(sql, parameters);
    }

    @Override
    public int queryForInt(String sql, Object[] parameters) throws DataAccessException {
        return this.dao.queryForInt(sql, parameters);
    }

    @Override
    public int queryForInt(String sql, Map<String, Object> parameters) throws DataAccessException {
        return this.dao.queryForInt(sql, parameters);
    }

    @Override
    public <T> T queryForObject(String sql, Object[] parameters, Class<T> clazz) throws DataAccessException {
        return this.dao.queryForObject(sql, parameters, clazz);
    }

    @Override
    public <T> T queryForObject(String sql, Map<String, Object> parameters, Class<T> clazz) throws DataAccessException {
        return this.dao.queryForObject(sql, parameters, clazz);
    }

    @Override
    public void execCall(String functionName, Object[] parameters) throws DataAccessException {
        this.dao.execCall(functionName, parameters);
    }

    @Override
    public <T> T execCall(String functionName, Object[] parameters, Class<T> clazz) throws DataAccessException {
        return this.dao.execCall(functionName, parameters, clazz);
    }

    @Override
    public int execBatchUpdate(String sql, List<?> parametersList) throws DataAccessException {
        return this.dao.execBatchUpdate(sql, parametersList);
    }

    @Override
    public void update(String sql) {
        this.dao.update(sql);
    }

    @Override
    public int update(String sql, Object[] args) {
        return this.dao.update(sql, args);
    }

    @Override
    public <T> List<T> sqlQuery(String sql, RowMapper<T> rowMapper) {
        return this.dao.sqlQuery(sql, rowMapper);
    }

    @Override
    public <T> List<T> sqlQuery(String sql, Object[] args, RowMapper<T> rowMapper) {
        return this.dao.sqlQuery(sql, args, rowMapper);
    }

    @Override
    public List<Map<String, Object>> sqlQueryListMap(String sql, Object[] args) {
        return this.dao.sqlQueryListMap(sql, args);
    }

    @Override
    public <E> GenericPager<E> sqlGeneralQueryPager(String sql, Object[] args, RowMapper<E> rowMapper) {
        return this.dao.sqlGeneralQueryPager(sql, args, rowMapper);
    }

    @Override
    public <E> GenericPager<E> sqlGeneralQueryPager(String sql, Object[] args, RowMapper<E> rowMapper, int pageIndex) {
        return this.dao.sqlGeneralQueryPager(sql, args, rowMapper, pageIndex);
    }

    @Override
    public <T> GenericPager<T> sqlGeneralQueryPager(String sql, Object[] args, RowMapper<T> rowMapper, int pageIndex, int pageSize) {
        return this.dao.sqlGeneralQueryPager(sql, args, rowMapper, pageIndex, pageSize);
    }

    @Override
    public <T> T sqlMathQuery(String sql, Object[] args, Class<T> clazz) {
        return this.dao.sqlMathQuery(sql, args, clazz);
    }

    @Override
    public <T> List<T> sqlListObjectWhereIn(String sql, RowMapper<T> rowMapper, SqlParameterSource paramSource) {
        return this.dao.sqlListObjectWhereIn(sql, rowMapper, paramSource);
    }

    @Override
    public List<Map<String, Object>> queryListObjectWhereIn(String sql, SqlParameterSource paramSource) {
        return this.dao.queryListObjectWhereIn(sql, paramSource);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(T po) throws DataAccessException {
        return this.dao.selectSplit(po);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(T po, Sorts.Sort sort) throws DataAccessException {
        return this.dao.selectSplit(po, sort);
    }

    @Override
    public <T extends BasePo<T>> List<T> selectAll(T po) {
        return this.dao.select("select * from " + this.convertToMapper(po).getTableName_(), new HashMap<String, Object>(), po);
    }

    @Override
    public int getMaxOrder(String tableName, String pidName, String pid) {
        StringBuilder sql = new StringBuilder("select max(sxh) from ").append(tableName);
        if (pid != null) {
            if (pid.equals("null")) {
                sql.append(" where ").append(pidName).append(" is null ");
            } else {
                sql.append(" where ").append(pidName).append(" = :pid");
            }
        }
        Object max = this.dao.queryForObject(sql.toString(), MapBuilder.map((String)"pid", (Object)pid), Object.class);
        return ConvertUtil.toInt((Object)max, (int)0);
    }

    @Override
    public void saveOrder(String tableName, String[] ids) {
        if (ids == null || ids.length < 1) {
            return;
        }
        String sql = "update " + tableName + " set sxh = :sxh where id = :id";
        ArrayList params = new ArrayList(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("sxh", i + 1);
            m.put("id", ids[i]);
            params.add(m);
        }
        this.execBatchUpdate(sql, params);
    }

    @Override
    public <T> void execute(String sql, Object[] parameters, RowMapper<T> rowMapper, BaseDao.RowExecution<T> rowExecution) {
        this.dao.execute(sql, parameters, rowMapper, rowExecution);
    }

    @Override
    public <T extends BasePo<T>> void execute(String sql, Object[] parameters, T po, BaseDao.RowExecution<T> rowExecution) {
        this.dao.execute(sql, parameters, po, rowExecution);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(String sql, Map<String, Object> parameters, T po) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, po);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(String sql, Object[] parameters, T po) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, po);
    }

    @Override
    public <T> GenericPager<T> selectSplit(String sql, Object[] parameters, RowMapper<T> rowMapper) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters, rowMapper);
    }

    @Override
    public MapPager selectSplit(String sql, Object[] parameters) throws DataAccessException {
        return this.dao.selectSplit(sql, parameters);
    }

    @Override
    public <T extends BasePo<T>> GenericPager<T> selectSplit(T po, String where, Map<String, Object> parameters) throws DataAccessException {
        return this.dao.selectSplit(po, where, parameters);
    }
}

