/*
 * Decompiled with CFR 0.152.
 */
package com.walker.jdbc.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.BasePo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class JdbcUtils {
    private static final Logger logger = LoggerFactory.getLogger(JdbcUtils.class);
    public static final String MAPPER_SUFFIX = "_mapper";
    private static final Map<String, Class<?>> cachedMapperClass = new ConcurrentHashMap();

    public static final <T extends BasePo<T>> Object[] acquireQueryCondition(T po) {
        Object[] result = new Object[2];
        ObjectNode objectNode = JsonUtils.javaObjectToObjectNode(po);
        Map.Entry entry = null;
        String fieldName = null;
        String valueText = null;
        JsonNode jsonNode = null;
        HashMap<String, Object> fieldNameAndValue = new HashMap<String, Object>(4);
        StringBuilder where = new StringBuilder("where");
        int i = 0;
        Iterator it = objectNode.fields();
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            if (((String)entry.getKey()).equals("parameter") || (jsonNode = (JsonNode)entry.getValue()) == null || jsonNode.toString().equals("null")) continue;
            fieldName = StringUtils.transferCamelName2Underline((String)((String)entry.getKey()));
            if (i > 0) {
                where.append(" ").append("and");
            }
            if (jsonNode.isTextual()) {
                valueText = jsonNode.asText();
                logger.debug("valueText = {}", (Object)valueText);
                if (StringUtils.isEmpty((String)valueText)) {
                    valueText = "";
                }
                if (valueText.indexOf("%") >= 0) {
                    where.append(" ").append(fieldName).append(" ").append("like").append(" ").append(":").append(fieldName);
                } else {
                    where.append(" ").append(fieldName).append("=").append(":").append(fieldName);
                }
                valueText = valueText.replace("\"", "");
                fieldNameAndValue.put(fieldName, valueText);
            } else {
                where.append(" ").append(fieldName).append("=").append(":").append(fieldName);
            }
            if (jsonNode.isLong()) {
                fieldNameAndValue.put(fieldName, jsonNode.longValue());
            } else if (jsonNode.isDouble()) {
                fieldNameAndValue.put(fieldName, jsonNode.doubleValue());
            } else if (jsonNode.isInt()) {
                fieldNameAndValue.put(fieldName, jsonNode.intValue());
            } else if (jsonNode.isFloat()) {
                fieldNameAndValue.put(fieldName, Float.valueOf(jsonNode.floatValue()));
            } else {
                fieldNameAndValue.put(fieldName, jsonNode.asText());
            }
            ++i;
        }
        if (where.length() <= 5) {
            logger.warn("po\u672a\u8bbe\u7f6e\u4efb\u4f55\u67e5\u8be2\u5b57\u6bb5:{}", (Object)po.getClass().getName());
            where.append(" 1=1 ");
        }
        result[0] = where.toString();
        result[1] = fieldNameAndValue;
        return result;
    }

    public static <T extends BasePo<T>> BaseMapper<T> getInstance(T basePo) {
        try {
            String className = basePo.getClass().getName() + MAPPER_SUFFIX;
            Class<?> mapperClass = cachedMapperClass.get(className);
            if (mapperClass == null) {
                mapperClass = Class.forName(className);
                cachedMapperClass.put(className, mapperClass);
            }
            return (BaseMapper)BeanUtils.instantiateClass(mapperClass.getConstructor(basePo.getClass()), (Object[])new Object[]{basePo});
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException(e.getMessage(), (Throwable)e);
        }
    }
}

