/*
 * Decompiled with CFR 0.152.
 */
package com.walker.jdbc.util;

import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.jdbc.util.StringUtils;

public class SqlUtils {
    public static final String SQL_REGEX = "select |insert |delete |update |drop |count |exec |chr |mid |master |truncate |char |and |declare ";
    public static final String SQL_PATTERN = "[a-zA-Z0-9_\\ \\,\\.]+";
    public static final String PAGE_PREFIX_ORACLE = "select * from (select row_.*, rownum rownum_ from (";
    public static final String PAGE_SUFFIX_ORACLE = ") row_ where rownum <= ?) where rownum_ >= ?";

    public static final String getOraclePageSql(String sql) {
        return PAGE_PREFIX_ORACLE + sql + PAGE_SUFFIX_ORACLE;
    }

    public static String escapeOrderBySql(String value) {
        if (StringUtils.isNotEmpty((String)value) && !SqlUtils.isValidOrderBySql(value)) {
            throw new ApplicationRuntimeException("\u53c2\u6570\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u4e0d\u80fd\u8fdb\u884c\u67e5\u8be2");
        }
        return value;
    }

    public static boolean isValidOrderBySql(String value) {
        return value.matches(SQL_PATTERN);
    }

    public static void filterKeyword(String value) {
        String[] sqlKeywords;
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        for (String sqlKeyword : sqlKeywords = StringUtils.split((String)SQL_REGEX, (String)"\\|")) {
            if (org.apache.commons.lang3.StringUtils.indexOfIgnoreCase((CharSequence)value, (CharSequence)sqlKeyword) <= -1) continue;
            throw new ApplicationRuntimeException("\u53c2\u6570\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669");
        }
    }
}

