/*
 * Decompiled with CFR 0.152.
 */
package com.walker.jdbc.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextUtils {
    protected static final transient Logger logger = LoggerFactory.getLogger(TextUtils.class);
    public static final char COLON_EN = ':';
    public static final char FOLDER_SEPARATOR = '/';
    public static final String DB_TYPE_DAMENG_PREFIX = "jdbc:dm:";

    public static final String[] parseIpAndPortFromUrl(String jdbcUrl) {
        boolean ipStart = false;
        boolean portStart = false;
        boolean dbStart = false;
        StringBuilder ipValue = null;
        StringBuilder portValue = null;
        StringBuilder dbValue = null;
        for (char c : jdbcUrl.toCharArray()) {
            if (c == ' ') continue;
            if (Character.isDigit(c)) {
                if (!ipStart && !portStart) {
                    ipValue = new StringBuilder();
                    ipStart = true;
                }
                if (ipStart) {
                    ipValue.append(c);
                    continue;
                }
                if (!portStart) continue;
                portValue.append(c);
                continue;
            }
            if (c == '.') {
                if (!ipStart) continue;
                ipValue.append(c);
                continue;
            }
            if (c == ':' && ipStart) {
                portValue = new StringBuilder();
                portStart = true;
                ipStart = false;
                continue;
            }
            if (c == '/' && portStart) {
                dbValue = new StringBuilder();
                portStart = false;
                dbStart = true;
                continue;
            }
            if (c == '?') {
                if (jdbcUrl.indexOf(DB_TYPE_DAMENG_PREFIX) >= 0) {
                    dbValue = new StringBuilder();
                    portStart = false;
                    dbStart = true;
                    continue;
                }
                dbStart = false;
                break;
            }
            if (!dbStart) continue;
            dbValue.append(c);
        }
        if (jdbcUrl.indexOf(DB_TYPE_DAMENG_PREFIX) >= 0) {
            String dbName = TextUtils.getDamengDbname(dbValue.toString());
            logger.debug("\u627e\u5230'\u8fbe\u68a6'\u6570\u636e\u5e93:{}", (Object)dbName);
            dbValue = new StringBuilder(dbName);
        }
        if (ipValue == null || portValue == null || dbValue == null) {
            logger.error("\u89e3\u6790ip\u548cport\u9519\u8bef:ip\u6216\u7aef\u53e3\u3001\u6570\u636e\u5e93\u540d\u79f0\u4e0d\u5b58\u5728, jdbcUrl = " + jdbcUrl);
            return null;
        }
        String[] ipAndPort = new String[]{ipValue.toString(), portValue.toString(), dbValue.toString()};
        return ipAndPort;
    }

    private static final String getDamengDbname(String dbValue) {
        String[] keyValues = dbValue.split("&");
        String[] parameter = null;
        for (String one : keyValues) {
            parameter = one.split("=");
            if (!parameter[0].equalsIgnoreCase("schema")) continue;
            return parameter[1];
        }
        return null;
    }
}

