package com.walker.openocr;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

public abstract class AbstractTextResolver<T,C> implements TextResolver<T,C>{

    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    private OcrType ocrType = null;

    @Override
    public T resolve(List<TextBlock> dataList, List<C> configList) {
        if(dataList == null || dataList.size() == 0){
            return null;
        }
        if(this.ocrType == OcrType.TextGeneric){
            return this.doResolveGeneric(dataList, configList);
        } else if(this.ocrType == OcrType.TextTable){
            return this.doResolveTable(dataList, configList);
        } else if(this.ocrType == OcrType.TextIdCard){
            return this.doResolveIdCard(dataList, configList);
        } else {
            throw new UnsupportedOperationException("暂未实现解析类型：" + this.ocrType.getIndex());
        }
    }

    @Override
    public void setOcrType(OcrType ocrType) {
        if(ocrType == null){
            logger.error("ocrType is null!");
            return;
        }
        this.ocrType = ocrType;
    }

    @Override
    public OcrType getOcrType() {
        return this.ocrType;
    }

    protected abstract T doResolveGeneric(List<TextBlock> dataList, List<C> configList);

    protected abstract T doResolveTable(List<TextBlock> dataList, List<C> configList);

    protected abstract T doResolveIdCard(List<TextBlock> dataList, List<C> configList);
}
