package com.walker.openocr;

import java.util.HashMap;
import java.util.List;

/**
 * OCR识别接口规范。
 * @author 时克英
 * @date 2023-10-16
 */
public interface OcrLoader {

    /**
     * 返回识别后的文本结果集合
     * @param image 图片二进制数据
     * @param options 识别选项
     * @return
     */
    List<TextBlock> loadText(byte[] image, HashMap<String, String> options);

    /**
     * 返回识别后的文本结果集合
     * @param imagePath 图片路径，本地图片
     * @param options 识别选项
     * @return
     */
    List<TextBlock> loadText(String imagePath, HashMap<String, String> options);

}
