package com.walker.openocr;

/**
 * 定义OCR服务类型，该参数会传入到：OpenOCR服务确认哪种模型数据。
 * @author 时克英
 * @date 2022-08-30
 */
public enum OcrType {

    TextGeneric{
        public String getIndex(){
            return TEXT_GENERIC;
        }
    },
    TextTable{
        public String getIndex(){
            return TEXT_TABLE;
        }
    },
    TextIdCard{
        public String getIndex(){
            return TEXT_ID_CARD;
        }
    };

    public String getIndex(){
        throw new AbstractMethodError();
    }

    public static OcrType getType(String type){
        if(type.equals(TEXT_GENERIC)){
            return TextGeneric;
        } else if(type.equals(TEXT_TABLE)){
            return TextTable;
        } else if(type.equals(TEXT_ID_CARD)){
            return TextIdCard;
        } else {
            throw new UnsupportedOperationException("暂不支持 OCR 类型：" + type);
        }
    }

    public static final String TEXT_GENERIC = "text";
    public static final String TEXT_TABLE = "table";
    public static final String TEXT_ID_CARD = "id_card";

}
