package com.walker.openocr;

/**
 * 属性值解析器，该接口规范解析识别文本中的特定属性值。
 * @param <T>
 * @date 2022-09-27
 * @author 时克英
 */
public interface ValueParser<T> {

    /**
     * 返回属性名字
     * @return
     */
    String getName();

    /**
     * 返回属性对应的具体值，通过一定算法或者规范来计算出可能的结果值。
     * @param input 给定的输入值
     * @return
     */
    T getValue(Object input);

    /**
     * 判断给定的属性值是否该类型值，如:车牌号等
     * @param input
     * @return
     */
    boolean isTypeValue(Object input);

    void setName(String name);
}
