package com.walker.openocr.support;

import com.baidu.aip.ocr.AipOcr;
import com.fasterxml.jackson.databind.JsonNode;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.openocr.AbstractOcrLoader;
import com.walker.openocr.TextBlock;
import com.walker.openocr.util.BaiduOcrUtils;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class BaiduOcrLoader extends AbstractOcrLoader {

    private HashMap<String, String> options;

    public BaiduOcrLoader(){

    }

    @Override
    public List<TextBlock> loadText(byte[] image, HashMap<String, String> options) {
        this.checkOcrClient();
        JSONObject res = client.general(image, options); // 包含位置
        if(res.has("error_code")){
            logger.error("调用返回错误：" + res.getString("error_msg"));
            return null;
        }

//        List<TextBlock> textBlocks = new ArrayList<>();
//        try {
//            JsonNode jsonNode = JsonUtils.jsonStringToObjectNode(res.toString(2));
//            JsonNode wordNode = null;
//            for(Iterator<JsonNode> it = jsonNode.get("words_result").elements(); it.hasNext();){
//                wordNode = it.next();
//                textBlocks.add(BaiduOcrUtils.acquireTextBlock(wordNode));
//            }
//        } catch (Exception e) {
//            logger.error("res = {}", res);
//            throw new ApplicationRuntimeException("百度返回json数据，系统解析错误:" + e.getMessage(), e);
//        }
        return this.doLoad(res);
    }

    @Override
    public List<TextBlock> loadText(String imagePath, HashMap<String, String> options) {
        this.checkOcrClient();
        JSONObject res = client.general(imagePath, options); // 包含位置
        if(res.has("error_code")){
            logger.error("调用返回错误：" + res.getString("error_msg"));
            return null;
        }
        return this.doLoad(res);
    }

    private List<TextBlock> doLoad(JSONObject res){
        List<TextBlock> textBlocks = new ArrayList<>();
        try {
            JsonNode jsonNode = JsonUtils.jsonStringToObjectNode(res.toString(2));
            JsonNode wordNode = null;
            for(Iterator<JsonNode> it = jsonNode.get("words_result").elements(); it.hasNext();){
                wordNode = it.next();
                textBlocks.add(BaiduOcrUtils.acquireTextBlock(wordNode));
            }
        } catch (Exception e) {
            logger.error("res = {}", res);
            throw new ApplicationRuntimeException("百度返回json数据，系统解析错误:" + e.getMessage(), e);
        }
        return textBlocks;
    }

    private void checkOcrClient(){
        if(this.client == null){
            if(StringUtils.isEmpty(this.appId) || StringUtils.isEmpty(this.apiKey) || StringUtils.isEmpty(this.secretKey)){
                throw new IllegalArgumentException("appId, apiKey, secretKey为空，无法初始化百度OCR client!");
           }
            client = new AipOcr(this.appId, this.apiKey, this.secretKey);
            // 可选：设置网络连接参数
            client.setConnectionTimeoutInMillis(2000);
            client.setSocketTimeoutInMillis(60000);

            // 传入可选参数调用接口
            options = new HashMap<String, String>();
            options.put("language_type", "CHN_ENG");
            options.put("detect_direction", "true");
            options.put("detect_language", "true");
            options.put("probability", "true");
            // 是否返回文字外接多边形顶点位置，不支持单字位置。默认为false
//        options.put("vertexes_location", "true");
            logger.info("百度: AipOcr初始化成功");
        }
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getApiKey() {
        return apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    private String appId;
    private String apiKey;
    private String secretKey;
    private AipOcr client = null;
}
