package com.walker.openocr.table;

public class CellConfigItem extends ConfigItem{

    // 有些内容并不存在单元格里面，因此无法通过“标题”查找值。
    // 这时候整个内容一体，需要依据内容解析。
    private boolean noneCell = false;

    // 文本内容结束标志，这个是精确文本，如：特别约定。
    private String endFlag = null;

    // 完整一行
    private boolean fullRow = false;

    // 单元格值，最小字符个数
    private int minValueSize = 3;

    public int getMinValueSize() {
        return minValueSize;
    }

    public void setMinValueSize(int minValueSize) {
        this.minValueSize = minValueSize;
    }

    public boolean isFullRow() {
        return fullRow;
    }

    public void setFullRow(boolean fullRow) {
        this.fullRow = fullRow;
    }

    public boolean isNoneCell() {
        return noneCell;
    }

    public void setNoneCell(boolean noneCell) {
        this.noneCell = noneCell;
    }

    public String getEndFlag() {
        return endFlag;
    }

    public void setEndFlag(String endFlag) {
        this.endFlag = endFlag;
    }

}
