package com.walker.openocr.table;

import com.walker.openocr.MultipleLine;

/**
 * 表格配置文件中，一个通用的（行、列）配置项定义。
 * @author 时克英
 * @date 2022-08-31
 */
public class ConfigItem {

    public static final String ALIGN_LEFT = "left";
    public static final String ALIGN_CENTER = "center";

    // 行或列id（唯一标识）
    private String id;
    // 中文名称
    private String name;
    // 序号，后续多个单元格需要排序
    private int orderNum = 0;
    // 文字对其方式：居左、居中，用于判断单元格位置计算
    private String align = ALIGN_LEFT;
    // 内容多行情况
    private MultipleLine multipleLine = MultipleLine.None;

    // 数据格式，后续会配置自定义实现类业务自己解析
    private String dataType = null;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(int orderNum) {
        this.orderNum = orderNum;
    }

    public String getAlign() {
        return align;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public MultipleLine getMultipleLine() {
        return multipleLine;
    }

    public void setMultipleLine(MultipleLine multipleLine) {
        this.multipleLine = multipleLine;
    }

    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    @Override
    public int hashCode(){
        return this.id.hashCode();
    }

    @Override
    public boolean equals(Object obj){
        if(obj == null){
            return false;
        }
        if(obj instanceof ConfigItem){
            ConfigItem item = (ConfigItem) obj;
            if(item.id.equals(this.id)){
                return true;
            }
        }
        return false;
    }
}
