package com.walker.openocr.table.config;

import com.walker.openocr.table.AbstractTableConfigLoader;
import com.walker.openocr.util.FileReaderUtils;

import java.io.File;
import java.util.List;

public class FileConfigLoader extends AbstractTableConfigLoader {

    @Override
    protected List<String> doLoadContent(Object option) {
        if(option == null){
            throw new IllegalArgumentException("没有文件路径，无法加载表格解析配置");
        }
        File file = new File(option.toString());
        if(!file.exists()){
            throw new IllegalArgumentException("配置文件不存在:" + option.toString());
        }
        return FileReaderUtils.getFileLines(option.toString());
    }
}
