package com.walker.openocr.table.config;

import com.walker.openocr.table.AbstractTableConfigLoader;
import com.walker.openocr.util.FileReaderUtils;

import java.io.InputStream;
import java.util.List;

/**
 * 通过文件流，加载OCR配置文件信息。
 * @author 时克英
 * @date 2023-10-16
 */
public class StreamConfigLoader extends AbstractTableConfigLoader {

    @Override
    protected List<String> doLoadContent(Object option) {
        if(option == null){
            throw new IllegalArgumentException("没有文件流，无法加载表格解析配置");
        }
        if(!(option instanceof InputStream)){
            throw new IllegalArgumentException("option必须是<code>InputStream</code>对象");
        }
        InputStream inputStream = (InputStream) option;
        return FileReaderUtils.getFileLines(inputStream);
    }
}
