package com.walker.openocr.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.openocr.TextBlock;

public class BaiduOcrUtils {

    /**
     * 从json结果（OCR识别返回的JSON字符串文本）中，把每个字快生成一个对象。
     * @param wordNode
     * @return
     * @author 时克英
     * @date 2023-10-10
     */
    public static final TextBlock acquireTextBlock(JsonNode wordNode){
        JsonNode locationNode = wordNode.get("location");
        int top = locationNode.get("top").asInt();
        int left = locationNode.get("left").asInt();
        int width = locationNode.get("width").asInt();
        int height = locationNode.get("height").asInt();
        float[] start = {left, top};
        float[] end   = {left+width, top};

        TextBlock textBlock = new TextBlock();
        String text = wordNode.get("words").toString().replaceAll("\"", StringUtils.EMPTY_STRING);
        textBlock.setText(text);
        textBlock.setStartPosition(start);
        textBlock.setEndPosition(end);
        textBlock.setScore(0);
        return textBlock;
    }
}
