package com.walker.openocr.util;

public class TextUtils {

    public static final String EMPTY_VALUE = "";
    public static final char DATE_SEPARATOR_MIDDLE_LINE = '-';
    public static final char DATE_SEPARATOR_LEAN_LINE = '/';

    public static final char COMMA_EN = ',';
    public static final char COMMA_ZH = '，';

    public static final boolean isEmpty(Object text){
        if(text == null || text.toString().equals(EMPTY_VALUE)){
            return true;
        }
        return false;
    }

    /**
     * 把原始字符串中移除给定的关键词集合。如：我爱祖国，给定关键词"祖国" --> 我爱
     * @param value 原始字符串
     * @param key 关键词，会拆分为每个字
     * @return
     */
    public static final String removeKeys(String value, String key){
        String[] keys = key.split(EMPTY_VALUE);  // 拆分为每个字替换为空
        for(String k : keys){
            value = value.replaceFirst(k, EMPTY_VALUE);
        }
        return value;
    }

    /**
     * 从字符串中解析出来两个数字日期。格式如下：
     * <pre>
     *     1) 自2022年3月14日00：00时起至2023年3月13日24：00时止
     *     2) 保险期间自2022年08月25日00时00分起至2023年08月24日24时00分止
     *
     * </pre>
     * @param text
     * @return 返回两个日期：2022-08-25, 2023-08-24，如果日月统一为2位数字
     * @author 时克英
     * @date 2022-09-06
     */
    public static final String[] parseDoubleDateWithNumber(String text){
        String[] array = {"",""};
        if(text == null || text.equals("")){
            return array;
        }

        boolean startNum = false;   // 是否开始一个日期过滤
        int count = 0;

        StringBuilder sb = null;
        for(char c : text.toCharArray()){
            if(count > 1){
                System.out.println("已经解析2个日期，结束");
                break;
            }
            if(c == 32){
                // 空格不管
                continue;
            }
            if(Character.isDigit(c)){
                // 遇到数字，只有遇到第一个不为0数字，才开始启动解析
                if(!startNum && c != '0'){
                    startNum = true;
                    sb = new StringBuilder();
                }
                if(startNum){
                    sb.append(c);
                    continue;
                }
            } else if(c == '年' || c == '月' || c == DATE_SEPARATOR_LEAN_LINE || c == DATE_SEPARATOR_MIDDLE_LINE){
                sb.append(DATE_SEPARATOR_MIDDLE_LINE);
                continue;

            } else if(c == '日'){
                array[count] = sb.toString();
                count ++;
                startNum = false;
                continue;
            }
        }

        // 如果日期中，月、日为一个字符，则替换为2位（补0）
        String one = null;
        String[] yearMonthDay = null;
        StringBuilder temp = null;
        for(int i=0; i<array.length; i++){
            one = array[i];
            if(one == null || one.equals(EMPTY_VALUE)){
                continue;
            }
            yearMonthDay = one.split("-");
            if(yearMonthDay.length != 3){
                System.out.println("解析的年月日有缺失，无法重新格式化:" + one);
                continue;
            }
            temp = new StringBuilder(yearMonthDay[0]);
            temp.append(DATE_SEPARATOR_MIDDLE_LINE);
            if(yearMonthDay[1].length() == 2){
                temp.append(yearMonthDay[1]);
            } else if(yearMonthDay[1].length() == 1){
                temp.append('0').append(yearMonthDay[1]);
            }

            temp.append(DATE_SEPARATOR_MIDDLE_LINE);
            if(yearMonthDay[2].length() == 2){
                temp.append(yearMonthDay[2]);
            } else if(yearMonthDay[2].length() == 1){
                temp.append('0').append(yearMonthDay[2]);
            }
            array[i] = temp.toString();
        }
        return array;
    }

    /**
     * 从字符串中解析出来遇到的第一个数字金额。格式如：
     * <pre>
     *     1) 保险费合计（人民币大写)：壹佰贰拾元整 (Y：120.00元)其中救助基金(1.00%）
     *     2) RMB284.32元（不含税保费：268.23元，税额：16.09元）（大写）人民币贰佰捌拾
     *     3) 总金额为12，006,599.01
     * </pre>
     * @param text
     * @return 返回 120.00元 | 284.32元
     */
    public static final String parseFirstMoneyNumber(String text){
        if(text == null || text.equals("")){
            return EMPTY_VALUE;
        }
        StringBuilder sb = new StringBuilder();
        boolean startNum = false;
        for(char c : text.toCharArray()){
            if(c == 32){
                // 空格不管
                continue;
            }
            if(c == COMMA_EN || c == COMMA_ZH){
                continue;
            }
            if(Character.isDigit(c)){
                if(!startNum && c != '0'){
                    startNum = true;
                }
                if(startNum){
                    sb.append(c);
                    continue;
                }
            } else if(c == '.'){
                sb.append(c);
                continue;
            } else if(startNum) {
                // 其他非数字字符，结束判断
                startNum = false;
                break;
            }
        }
        return sb.toString();
    }

}
