package com.walker.openocr.vehicle;

import com.walker.openocr.AbstractValueParser;
import com.walker.openocr.util.TextUtils;

/**
 * 所有人所在地址属性值解析器实现。
 * @author 时克英
 * @date 2022-09-26
 */
public class AddressValueParser extends AbstractValueParser<String> {

    private static final String NAME_PROVINCE = "省";
    private static final String NAME_CITY = "市";
    private static final String NAME_AREA = "区";
    private static final String NAME_NUMBER = "号";

    @Override
    public String getValue(Object input) {
        if(this.isTypeValue(input)){
            return input.toString();
        }
        return null;
    }

    @Override
    public boolean isTypeValue(Object input) {
        if(TextUtils.isEmpty(input)){
            return false;
        }
        String text = input.toString();
        if(text.length() < 5){
            return false;
        }
        if((text.indexOf(NAME_PROVINCE) >= 0 && text.indexOf(NAME_CITY) >= 0 && text.indexOf(NAME_NUMBER) >= 0)
            || (text.indexOf(NAME_CITY) >= 0 && text.indexOf(NAME_AREA) >= 0 && text.indexOf(NAME_NUMBER) >= 0)){
            // 包含：省、市、号，或者市、区、号，关键词，可能是地址
            return true;
        }
        return false;
    }
}
