package com.walker.openocr.vehicle;

import com.walker.openocr.AbstractValueParser;
import com.walker.openocr.util.TableConfigUtils;
import com.walker.openocr.util.TextUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 车辆类型属性值解析实现。
 * @author 时克英
 * @date 2022-09-27
 */
public class CarTypeValueParser extends AbstractValueParser<String> {

    private List<String> standardTypeSet = new ArrayList<>(12);

    public CarTypeValueParser(){
        this.standardTypeSet.add("微型轿车");
        this.standardTypeSet.add("小型轿车");
        this.standardTypeSet.add("中型轿车");
        this.standardTypeSet.add("大型轿车");
        this.standardTypeSet.add("小型普通客车");
        this.standardTypeSet.add("小型越野客车");
        this.standardTypeSet.add("小型专用客车");
        this.standardTypeSet.add("微型普通客车");
        this.standardTypeSet.add("微型越野客车");
    }

    @Override
    public String getValue(Object input) {
        if(TextUtils.isEmpty(input)){
            return null;
        }
        String text = input.toString();
        double maxScore = 0;
        double currentScore = 0;
        int maxIndex = 0;
        for(int i=0; i<this.standardTypeSet.size(); i++){
            currentScore = TableConfigUtils.getSimpleSimilarScore(this.standardTypeSet.get(i), text);
            if(currentScore > maxScore){
                maxScore = currentScore;
                maxIndex = i;
            }
        }
        if(maxScore >= 0.7){
            logger.debug("maxScore = " + maxScore + ", index = " + maxIndex);
            return this.standardTypeSet.get(maxIndex);
        }
        return null;
    }

    @Override
    public boolean isTypeValue(Object input) {
        return this.getValue(input) != null;
    }

}
