package com.walker.openocr.vehicle;

import com.walker.openocr.AbstractValueParser;
import com.walker.openocr.util.TextUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 机动车车牌属性解析器实现，能判断给定值是否车牌号码。
 * @author 时克英
 * @date 2022-09-27
 */
public class PlateValueParser extends AbstractValueParser<String> {

    private Map<String, String> provinceMap = new HashMap<>(32);
    private List<String> areaMap = new ArrayList<>(32);

    public PlateValueParser(){
        this.provinceMap.put("京","北京");
        this.provinceMap.put("津","天津");
        this.provinceMap.put("冀","河北");
        this.provinceMap.put("晋","山西");
        this.provinceMap.put("辽","辽宁");
        this.provinceMap.put("吉","吉林");
        this.provinceMap.put("沪","上海");
        this.provinceMap.put("苏","江苏");
        this.provinceMap.put("浙","浙江");
        this.provinceMap.put("皖","安徽");
        this.provinceMap.put("闽","福建");
        this.provinceMap.put("琼","海南");
        this.provinceMap.put("赣","江西");
        this.provinceMap.put("鲁","山东");
        this.provinceMap.put("豫","河南");
        this.provinceMap.put("鄂","湖北");
        this.provinceMap.put("湘","湖南");
        this.provinceMap.put("粤","广东");
        this.provinceMap.put("渝","重庆");
        this.provinceMap.put("川","四川");
        this.provinceMap.put("贵","贵州");
        this.provinceMap.put("云","云南");
        this.provinceMap.put("陕","陕西");
        this.provinceMap.put("甘","甘肃");
        this.provinceMap.put("蒙","内蒙古");
        this.provinceMap.put("黑","黑龙江");
        this.provinceMap.put("桂","广西");
        this.provinceMap.put("青","青海");
        this.provinceMap.put("宁","宁夏");

        this.areaMap.add("A");
        this.areaMap.add("B");
        this.areaMap.add("C");
        this.areaMap.add("D");
        this.areaMap.add("E");
        this.areaMap.add("F");
        this.areaMap.add("G");
        this.areaMap.add("H");
        this.areaMap.add("J");
        this.areaMap.add("K");
        this.areaMap.add("L");
        this.areaMap.add("M");
        this.areaMap.add("N");
        this.areaMap.add("P");
        this.areaMap.add("Q");
        this.areaMap.add("R");
        this.areaMap.add("S");
        this.areaMap.add("T");
        this.areaMap.add("U");
        this.areaMap.add("V");
        this.areaMap.add("W");
        this.areaMap.add("X");
        this.areaMap.add("Y");
        this.areaMap.add("Z");
    }

    @Override
    public String getValue(Object input) {
        if(this.isTypeValue(input)){
            return input.toString();
        }
        return null;
    }

    @Override
    public boolean isTypeValue(Object input) {
        if(TextUtils.isEmpty(input)){
            return false;
        }
        String text = input.toString();
        if(text.length() != 7){
            // 长度不够
            return false;
        }
        if(this.provinceMap.get(text.substring(0,1)) == null){
            // 第一位不是省份简称
            return false;
        }
        if(!this.areaMap.contains(text.substring(1,2))){
            // 第二位不包含大写字母
            return false;
        }

        return true;
    }
}
