package com.walker.openocr.vehicle;

import com.walker.openocr.TextBlock;
import com.walker.openocr.ValueParser;
import com.walker.openocr.table.TableConfig;
import com.walker.openocr.table.TableObject;
import com.walker.openocr.table.TableTextResolver;

import java.util.ArrayList;
import java.util.List;

/**
 * 行驶证文本解析器实现，暂时使用表格统一解析过程，创建专用模板。
 * @author 时克英
 * @date 2022-09-27
 */
public class VehicleLicenseResolver extends TableTextResolver {

    public VehicleLicenseResolver(){
        super();
    }

    @Override
    protected TableObject doResolveTable(List<TextBlock> dataList, List<TableConfig> configList) {
        if(configList == null || configList.size() == 0){
            logger.error("table configList 未设置，无法解析'行驶证'对象");
            return null;
        }

        TableConfig tableConfig = configList.get(0);

        PlateValueParser plateValueParser = new PlateValueParser();
        plateValueParser.setName("hao_pai_hao_ma");
        CarTypeValueParser carTypeValueParser = new CarTypeValueParser();
        carTypeValueParser.setName("che_liang_lei_xing");
        AddressValueParser addressValueParser = new AddressValueParser();
        addressValueParser.setName("zhu_zhi");
        IdValueParser idValueParser = new IdValueParser();
        idValueParser.setName("che_liang_shi_bie_dai_ma");

        List<ValueParser> valueParserList = new ArrayList<>(8);
        valueParserList.add(plateValueParser);
        valueParserList.add(carTypeValueParser);
        valueParserList.add(addressValueParser);
        valueParserList.add(idValueParser);

        VehicleLicenseTable tableObject = new VehicleLicenseTable(tableConfig, valueParserList);

//        List<TextBlock> availableList = this.filterRemovedNames(tableConfig, dataList);
//        if(availableList != null){
//            for(TextBlock tb : availableList){
//                tableObject.addTextBlock(tb);
//            }
//        }
//        tableObject.sortCellObjectList();
//        tableObject.calculateValue();
//        tableObject.printRowCache();
        this.flowTableObject(tableObject, tableConfig, dataList);

        return tableObject;
    }
}
