package com.walker.openocr.vehicle;

import com.walker.openocr.ValueParser;
import com.walker.openocr.table.CellObject;
import com.walker.openocr.table.TableConfig;
import com.walker.openocr.table.TableObject;
import com.walker.openocr.util.TextUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 行驶证识别结果对象定义。
 * @author 时克英
 * @date 2022-09-27
 */
public class VehicleLicenseTable extends TableObject {

    // 属性id 与 解析器关联
    private Map<String, ValueParser> idParserMap = new HashMap<>(8);

    private Map<String, CellObject> tableData = new HashMap<>();

    public VehicleLicenseTable(TableConfig tableConfig, List<ValueParser> valueParserList) {
        super(tableConfig);
        if(valueParserList == null || valueParserList.size() == 0){
            logger.warn("valueParserList 没有设置，无法更好解析行驶证属性参数");
        } else {
            for(ValueParser valueParser : valueParserList){
                idParserMap.put(valueParser.getName(), valueParser);
            }
        }
    }

    @Override
    public void printRowCache(){
        super.printRowCache();
        logger.debug("~~~~~~~~~~~~~~~~~ table data ~~~~~~~~~~~~~~~~~");
        for(CellObject other : this.tableData.values()){
            logger.debug(other.toString());
        }
    }

    @Override
    public Map<String, CellObject> getTableDataMap(){
        return this.tableData;
    }

    @Override
    public void calculateValue(){
        super.calculateValue();

        //
//        Map<String, CellObject> map = new HashMap<>();
        if(this.rowCache.size() > 0){
            for (List<CellObject> list : this.rowCache.values()){
                for(CellObject co : list){
                    if(co.isConfigurable()){
                        tableData.put(co.getId(), co);
                    }
                }
            }
        }

        // 把没有解析到的属性值，通过简单数据推断后设置到属性中。
        this.predictValue("hao_pai_hao_ma");
        this.predictValue("che_liang_lei_xing");
        this.predictValue("zhu_zhi");
        this.predictValue("che_liang_shi_bie_dai_ma");
    }

    private void predictValue(String id){
        ValueParser valueParser = this.idParserMap.get(id);
        CellObject one = tableData.get(id);
        if(one != null && !TextUtils.isEmpty(one.getValue())){
            if(valueParser != null){
                if(valueParser.isTypeValue(one.getValue())){
                    return;
                }
            }
        } else if(one != null && one.getValue() == null){
            if(valueParser != null){
                if(valueParser.isTypeValue(one.getValue())){
                    return;
                }
            }
        } else if(one == null){
            // 没有解析到该属性
            one = new CellObject();
            one.setId(id);
            tableData.put(id, one);
        }

        String predictValue = this.parseValue(id, valueParser);
        if(predictValue != null){
            if(!one.isConfigurable()){
                logger.debug(predictValue + " 没有配置项，创建一个: " + id);
                one.setCellConfigItem(this.getRecognizeConfig().getCellConfigItem(id));
            }
            one.setValue(predictValue);
            one.setId(id);
        }
    }

    private String parseValue(String id, ValueParser valueParser){
//        ValueParser valueParser = this.idParserMap.get(id);
        if(valueParser == null){
            return null;
        }
        Object result = null;
        for (List<CellObject> list : this.rowCache.values()){
            for(CellObject co : list){
                result = valueParser.getValue(co.getSource().getText());
                if(result != null){
                    logger.debug("找到成功解析的属性值:" + co.getId() + ", " + co.getSource().getText());
                    return result.toString();
                }
            }
        }
        // 从其他属性搜索
        if(result == null){
            for(CellObject co : this.otherCellObjectList){
                result = valueParser.getValue(co.getSource().getText());
                if(result != null){
                    logger.debug("找到'otherCellObjectList'解析的属性值:" + co.getId() + ", " + co.getSource().getText());
                    return result.toString();
                }
            }
        }
        return null;
    }
}
