/*
 * Decompiled with CFR 0.152.
 */
package com.walker.openocr;

import com.walker.openocr.TextBlock;
import com.walker.openocr.table.CellObject;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RecognizeResult<T> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Map<Integer, List<CellObject>> rowCache = new TreeMap<Integer, List<CellObject>>();

    public void printRowCache() {
        List<CellObject> data = null;
        for (Map.Entry<Integer, List<CellObject>> entry : this.rowCache.entrySet()) {
            this.logger.debug("\u7b2c " + entry.getKey() + " \u884c ==========================================");
            data = entry.getValue();
            if (data == null) continue;
            for (CellObject co : data) {
                this.logger.debug(co.toString());
            }
        }
    }

    public abstract void addTextBlock(TextBlock var1);

    public abstract void sortCellObjectList();

    public abstract void calculateValue();

    public abstract T getRecognizeConfig();
}

