/*
 * Decompiled with CFR 0.152.
 */
package com.walker.openocr.idcard;

import com.walker.openocr.RecognizeResult;
import com.walker.openocr.TextBlock;
import com.walker.openocr.idcard.IdCardConfig;
import com.walker.openocr.table.CellObject;
import com.walker.openocr.util.TableObjectUtils;
import com.walker.openocr.util.TextUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IdCardObject
extends RecognizeResult<IdCardConfig> {
    private List<CellObject> otherCellObjectList = new ArrayList<CellObject>();
    private IdCardConfig idCardConfig = null;
    private int cardSide = 1;
    private String name;
    private String sex;
    private String nation;
    private String birthday;
    private String address;
    private String cardNo;
    private String signOffice;
    private String dateStart;
    private String dateEnd;

    public String getName() {
        return this.name;
    }

    public String getSex() {
        return this.sex;
    }

    public String getNation() {
        return this.nation;
    }

    public String getBirthday() {
        return this.birthday;
    }

    public String getAddress() {
        return this.address;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getSignOffice() {
        return this.signOffice;
    }

    public String getDateStart() {
        return this.dateStart;
    }

    public String getDateEnd() {
        return this.dateEnd;
    }

    public IdCardObject(IdCardConfig idCardConfig) {
        this.idCardConfig = idCardConfig == null ? new IdCardConfig() : idCardConfig;
    }

    @Override
    public void calculateValue() {
        this.recognizeCardSide();
        if (this.cardSide == 0) {
            if (this.rowCache.size() < 5) {
                this.logger.warn("\u8eab\u4efd\u8bc1\u6b63\u9762\u89e3\u6790\u5230\u7684\u884c\u6570\u8fc7\u5c11\uff08\u5c0f\u4e8e5\u884c\uff09\uff0c\u53ea\u80fd\u6839\u636e\u5185\u5bb9\u5173\u952e\u8bcd\u89e3\u6790!");
                this.parseCardFrontInfo();
            } else {
                this.logger.info("\u6b63\u786e\u8bc6\u522b\u5230\u8eab\u4efd\u8bc1\u6b63\u9762\u884c\u6570\u636e\uff0c\u4f9d\u636e\u884c\u89e3\u6790");
                this.parseCardFrontInfo();
            }
        } else {
            throw new UnsupportedOperationException("\u6682\u672a\u5b9e\u73b0\u53cd\u9762\u89e3\u6790\u4ee3\u7801");
        }
    }

    @Override
    public IdCardConfig getRecognizeConfig() {
        return this.idCardConfig;
    }

    private void parseCardFrontInfo() {
        if (this.rowCache.size() > 6) {
            this.logger.error("\u8eab\u4efd\u8bc1\u6b63\u9762\u89e3\u6790\u5230\u884c\u6570\u592a\u591a\uff0c\u5927\u4e8e6\u884c\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u56fe\u7247\u6709\u8bef\uff0c\u53ea\u89e3\u6790\u524d6\u884c\u6570\u636e!");
        }
        if (this.rowCache.size() >= 6) {
            CellObject addressTwoLineCell = (CellObject)((List)this.rowCache.get(5)).get(0);
            addressTwoLineCell.setOrderColumn(9);
            ((List)this.rowCache.get(4)).add(addressTwoLineCell);
            List addressRowList = (List)this.rowCache.get(4);
            TableObjectUtils.sortColumnCellList(addressRowList);
            this.rowCache.remove(5);
            this.rowCache.put(5, (List)this.rowCache.get(6));
        }
        int realRows = this.rowCache.size();
        List data = null;
        for (int rowNum = 1; rowNum < 6; ++rowNum) {
            if (rowNum > realRows) {
                this.logger.debug("\u8d85\u8fc7\u6700\u5927\u884c\uff0c\u4e0d\u5728\u89e3\u6790\u3002rowNum=" + rowNum + ", realRows=" + realRows);
                continue;
            }
            data = (List)this.rowCache.get(rowNum);
            if (rowNum == 1) {
                this.name = this.parseOneField(data, "\u59d3\u540d", rowNum);
                continue;
            }
            if (rowNum == 3) {
                this.birthday = this.parseOneField(data, "\u51fa\u751f", rowNum);
                continue;
            }
            if (rowNum == 5) {
                this.cardNo = this.parseOneField(data, "\u516c\u6c11\u8eab\u4efd\u53f7\u7801", rowNum);
                continue;
            }
            if (rowNum == 2) {
                String[] sexNation = this.parseSexNation(data);
                if (sexNation == null || sexNation.length != 2) {
                    this.logger.error("\u89e3\u6790\u6027\u522b\u3001\u6c11\u65cf\u9519\u8bef\uff0c\u8fd4\u56de\u6570\u636e\u7f3a\u5931:" + data);
                    continue;
                }
                this.sex = sexNation[0];
                this.nation = sexNation[1];
                continue;
            }
            if (rowNum != 4) continue;
            this.address = this.parseAddress(data);
        }
    }

    private String[] parseSexNation(List<CellObject> data) {
        String[] result = new String[2];
        StringBuilder sb = new StringBuilder();
        for (CellObject co : data) {
            sb.append(co.getSource().getText().trim());
        }
        String value = sb.toString();
        value = TextUtils.removeKeys(value, "\u6027\u522b");
        if ((value = TextUtils.removeKeys(value, "\u6c11\u65cf")).indexOf("\u7537") >= 0) {
            result[0] = "\u7537";
        } else if (value.indexOf("\u5973") >= 0) {
            result[0] = "\u5973";
        } else {
            this.logger.warn("\u672a\u89e3\u6790\u5230\u6027\u522b:" + value);
            result[0] = "";
        }
        result[1] = value = TextUtils.removeKeys(value, "\u7537\u5973");
        return result;
    }

    private String parseAddress(List<CellObject> data) {
        Object value = null;
        CellObject temp = null;
        Iterator<CellObject> it = data.iterator();
        while (it.hasNext()) {
            temp = it.next();
            value = TextUtils.removeKeys(temp.getSource().getText(), "\u4f4f\u5740");
            if (value == null || !((String)value).equals("")) continue;
            this.logger.debug("\u79fb\u9664'\u4f4f\u5740'\u5355\u5143\u683c:" + (String)value);
            it.remove();
            break;
        }
        this.logger.debug("\u4f4f\u5740\u5355\u5143\u683c\u6570\u91cf:" + data.size());
        value = "";
        for (CellObject co : data) {
            value = (String)value + co.getSource().getText();
        }
        return value;
    }

    private String parseOneField(List<CellObject> data, String key, int rowNum) {
        String value = null;
        if (data.size() == 2) {
            if (data.get(0).getSource().getText().equals(key)) {
                value = data.get(1).getSource().getText();
                this.logger.debug("\u5339\u914d\u5230\u5173\u952e\u5b57\u6bb5:" + key + ", value=" + value);
                return value;
            }
            value = data.get(1).getSource().getText();
            return value;
        }
        if (data.size() == 1) {
            value = data.get(0).getSource().getText();
            return TextUtils.removeKeys(value, key);
        }
        this.logger.error("\u884c\u4e2d\u6ca1\u6709\u4efb\u4f55\u6570\u636e\uff0crow=" + rowNum);
        return null;
    }

    @Override
    public void sortCellObjectList() {
        CellObject target = null;
        int currentRow = 1;
        Iterator<CellObject> it = this.otherCellObjectList.iterator();
        while (it.hasNext()) {
            target = it.next();
            List rowSet = null;
            boolean sameRow = false;
            if (this.rowCache.size() == 0) {
                this.createNewRow(target, currentRow);
                ++currentRow;
                continue;
            }
            for (Map.Entry entry : this.rowCache.entrySet()) {
                rowSet = (List)entry.getValue();
                sameRow = TableObjectUtils.isInSameRow((CellObject)rowSet.get(0), target, this.idCardConfig.getCellTolerance());
                if (!sameRow) continue;
                this.logger.debug("\u627e\u5230\u5339\u914d\u884c:" + entry.getKey() + ", target=" + target.getSource().getText());
                rowSet.add(target);
                it.remove();
                break;
            }
            if (sameRow) continue;
            this.createNewRow(target, currentRow);
            ++currentRow;
        }
        for (List list : this.rowCache.values()) {
            TableObjectUtils.sortColumnCellList(list);
        }
    }

    @Override
    public void addTextBlock(TextBlock textBlock) {
        CellObject cellObject = new CellObject();
        cellObject.setSource(textBlock);
        cellObject.setId(this.generateCellId());
        this.otherCellObjectList.add(cellObject);
    }

    private void recognizeCardSide() {
        List<String> idcardFrontKeys = this.idCardConfig.getIdCardFrontKeys();
        for (List list : this.rowCache.values()) {
            block1: for (CellObject co : list) {
                for (String key : idcardFrontKeys) {
                    if (co.getSource().getText().indexOf(key) < 0) continue;
                    this.logger.debug("\u627e\u5230\u8eab\u4efd\u8bc1\uff08\u6b63\u9762\uff09\u5173\u952e\u8bcd:" + key);
                    this.cardSide = 0;
                    continue block1;
                }
            }
        }
    }

    private void createNewRow(CellObject target, int rowNumber) {
        ArrayList<CellObject> rowSet = new ArrayList<CellObject>(4);
        rowSet.add(target);
        this.rowCache.put(rowNumber, rowSet);
    }

    private String generateCellId() {
        return String.valueOf(System.nanoTime());
    }

    public String toString() {
        return "[name=" + this.name + ", sex=" + this.sex + ", nation=" + this.nation + ", birthday=" + this.birthday + ", address=" + this.address + ", no=" + this.cardNo + ", side=" + this.cardSide + "]";
    }
}

