/*
 * Decompiled with CFR 0.152.
 */
package com.walker.openocr.support;

import com.baidu.aip.ocr.AipOcr;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.openocr.AbstractOcrLoader;
import com.walker.openocr.TextBlock;
import com.walker.openocr.util.BaiduOcrUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;

public class BaiduOcrLoader
extends AbstractOcrLoader {
    private HashMap<String, String> options;
    private String appId;
    private String apiKey;
    private String secretKey;
    private AipOcr client = null;

    @Override
    public List<TextBlock> loadText(byte[] image, HashMap<String, String> options) {
        this.checkOcrClient();
        JSONObject res = this.client.general(image, options);
        if (res.has("error_code")) {
            this.logger.error("\u8c03\u7528\u8fd4\u56de\u9519\u8bef\uff1a" + res.getString("error_msg"));
            return null;
        }
        return this.doLoad(res);
    }

    @Override
    public List<TextBlock> loadText(String imagePath, HashMap<String, String> options) {
        this.checkOcrClient();
        JSONObject res = this.client.general(imagePath, options);
        if (res.has("error_code")) {
            this.logger.error("\u8c03\u7528\u8fd4\u56de\u9519\u8bef\uff1a" + res.getString("error_msg"));
            return null;
        }
        return this.doLoad(res);
    }

    private List<TextBlock> doLoad(JSONObject res) {
        ArrayList<TextBlock> textBlocks = new ArrayList<TextBlock>();
        try {
            ObjectNode jsonNode = JsonUtils.jsonStringToObjectNode((String)res.toString(2));
            JsonNode wordNode = null;
            Iterator it = jsonNode.get("words_result").elements();
            while (it.hasNext()) {
                wordNode = (JsonNode)it.next();
                textBlocks.add(BaiduOcrUtils.acquireTextBlock(wordNode));
            }
        }
        catch (Exception e) {
            this.logger.error("res = {}", (Object)res);
            throw new ApplicationRuntimeException("\u767e\u5ea6\u8fd4\u56dejson\u6570\u636e\uff0c\u7cfb\u7edf\u89e3\u6790\u9519\u8bef:" + e.getMessage(), (Throwable)e);
        }
        return textBlocks;
    }

    private void checkOcrClient() {
        if (this.client == null) {
            if (StringUtils.isEmpty((String)this.appId) || StringUtils.isEmpty((String)this.apiKey) || StringUtils.isEmpty((String)this.secretKey)) {
                throw new IllegalArgumentException("appId, apiKey, secretKey\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u521d\u59cb\u5316\u767e\u5ea6OCR client!");
            }
            this.client = new AipOcr(this.appId, this.apiKey, this.secretKey);
            this.client.setConnectionTimeoutInMillis(2000);
            this.client.setSocketTimeoutInMillis(60000);
            this.options = new HashMap();
            this.options.put("language_type", "CHN_ENG");
            this.options.put("detect_direction", "true");
            this.options.put("detect_language", "true");
            this.options.put("probability", "true");
            this.logger.info("\u767e\u5ea6: AipOcr\u521d\u59cb\u5316\u6210\u529f");
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }
}

