/*
 * Decompiled with CFR 0.152.
 */
package com.walker.openocr.table;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.openocr.MultipleLine;
import com.walker.openocr.table.CellConfigItem;
import com.walker.openocr.table.TableConfig;
import com.walker.openocr.table.TableConfigLoader;
import com.walker.openocr.util.JsonUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableConfigLoader
implements TableConfigLoader {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String NAME_TABLE_TITLE = "table_title";
    private static final String NAME_TABLE_TYPE_KEYS = "table_type_keys";
    private static final String NAME_TABLE_TYPE_KEYS_NOT = "table_type_keys_not";
    private static final String NAME_TABLE_SETTING = "table_setting";
    private static final String NAME_REMOVE_COLUMNS = "remove_columns";
    private static final String KEY_CELL_TOLERANCE = "cell_tolerance";
    private static final String KEY_TITLE_TOLERANCE = "title_tolerance";
    private static final String KEY_MULTI_LINE_TOLERANCE = "multi_line_tolerance";
    private static final String KEY_CELL_NAME = "name";
    private static final String KEY_MULTI_LINE = "multi_line";
    private static final String KEY_NONE_CESS = "none_cell";
    private static final String KEY_END_FLAG = "end_flag";
    private static final String KEY_ALIGN = "align";
    private static final String KEY_DATA_TYPE = "data_type";
    private static final String KEY_ORDER_NUM = "order_num";
    private static final String KEY_FULL_ROW = "full_row";
    private static final String KEY_MIN_VALUE_SIZE = "min_value_size";

    @Override
    public TableConfig load(Object option) {
        List<String> configContent = this.doLoadContent(option);
        if (configContent == null || configContent.size() == 0) {
            this.logger.error("\u672a\u52a0\u8f7d\u5230\u914d\u7f6e\u9879\u5185\u5bb9:" + option);
            return null;
        }
        TableConfig tableConfig = new TableConfig();
        try {
            String[] keyValue = null;
            for (String line : configContent) {
                if (line.startsWith("#")) continue;
                keyValue = line.split("=");
                if (keyValue.length != 2) {
                    if (keyValue.length == 1) {
                        this.logger.warn("\u8be5\u5c5e\u6027\u6ca1\u6709\u914d\u7f6e\u4efb\u4f55\u503c:" + line);
                        continue;
                    }
                    throw new IllegalArgumentException("\u89e3\u6790\u8868\u683c\u914d\u7f6e\u884c\u9519\u8bef\uff0c\u7b49\u53f7\u5de6\u53f3\u5fc5\u987b\u90fd\u6709\u503c\uff0c\u914d\u7f6e\u4e0d\u6b63\u786e:" + line);
                }
                this.logger.debug("\u52a0\u8f7dkey:" + keyValue[0] + ", value=" + keyValue[1]);
                if (keyValue[0].equals(NAME_TABLE_TYPE_KEYS)) {
                    this.processTableTypeKeys(keyValue[1], tableConfig);
                    continue;
                }
                if (keyValue[0].equals(NAME_TABLE_TYPE_KEYS_NOT)) {
                    this.processTableTypeKeysNot(keyValue[1], tableConfig);
                    continue;
                }
                if (keyValue[0].equals(NAME_TABLE_SETTING)) {
                    this.processTableSetting(keyValue[1], tableConfig);
                    continue;
                }
                if (keyValue[0].equals(NAME_REMOVE_COLUMNS)) {
                    this.processRemoveColumns(keyValue[1], tableConfig);
                    continue;
                }
                if (keyValue[0].equals(NAME_TABLE_TITLE)) {
                    tableConfig.setTableTitle(keyValue[1]);
                    continue;
                }
                this.processCellConfig(keyValue[0], keyValue[1], tableConfig);
            }
            this.logger.info("\u52a0\u8f7d\u5b8c\u6210 TableConfig:" + option);
        }
        catch (Exception ex) {
            this.logger.error("\u89e3\u6790\u8868\u683c\u914d\u7f6e\u51fa\u73b0\u9519\u8bef:" + option, (Throwable)ex);
        }
        return tableConfig;
    }

    private void processCellConfig(String key, String value, TableConfig tableConfig) throws Exception {
        Object minValueSize;
        Object fullRow;
        Object endFlag;
        Object noneCell;
        Object dataType;
        Object multipleLine;
        Object align;
        Object orderNum;
        Map map = JsonUtils.jsonStringToObject(value, Map.class);
        if (map == null || map.size() == 0) {
            return;
        }
        CellConfigItem item = new CellConfigItem();
        item.setId(key);
        Object name = map.get(KEY_CELL_NAME);
        if (name != null) {
            item.setName(name.toString());
        }
        if ((orderNum = map.get(KEY_ORDER_NUM)) != null) {
            item.setOrderNum(Integer.parseInt(orderNum.toString()));
        }
        if ((align = map.get(KEY_ALIGN)) != null) {
            item.setAlign(align.toString());
        }
        if ((multipleLine = map.get(KEY_MULTI_LINE)) != null) {
            item.setMultipleLine(MultipleLine.getType(multipleLine.toString()));
        }
        if ((dataType = map.get(KEY_DATA_TYPE)) != null) {
            item.setDataType(dataType.toString());
        }
        if ((noneCell = map.get(KEY_NONE_CESS)) != null) {
            item.setNoneCell(Boolean.parseBoolean(noneCell.toString()));
        }
        if ((endFlag = map.get(KEY_END_FLAG)) != null) {
            item.setEndFlag(endFlag.toString());
        }
        if ((fullRow = map.get(KEY_FULL_ROW)) != null) {
            item.setFullRow(Boolean.parseBoolean(fullRow.toString()));
        }
        if ((minValueSize = map.get(KEY_MIN_VALUE_SIZE)) != null) {
            item.setMinValueSize(Integer.parseInt(minValueSize.toString()));
        }
        tableConfig.addCellConfig(item);
    }

    private void processRemoveColumns(String text, TableConfig tableConfig) {
        String[] names = text.split(",");
        tableConfig.setRemoveColumnsName(names);
    }

    private void processTableSetting(String text, TableConfig tableConfig) throws Exception {
        Object multiLineTolerance;
        Object titleTolerance;
        Map map = JsonUtils.jsonStringToObject(text, Map.class);
        if (map == null || map.size() == 0) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u8868\u683c\u914d\u7f6e\u9879:table_setting");
        }
        Object cellTolerance = map.get(KEY_CELL_TOLERANCE);
        if (cellTolerance != null) {
            tableConfig.setCellTolerance(Integer.parseInt(cellTolerance.toString()));
        }
        if ((titleTolerance = map.get(KEY_TITLE_TOLERANCE)) != null) {
            tableConfig.setTitleTolerance(Float.parseFloat(titleTolerance.toString()));
        }
        if ((multiLineTolerance = map.get(KEY_MULTI_LINE_TOLERANCE)) != null) {
            tableConfig.setMultiLineTolerance(Integer.parseInt(multiLineTolerance.toString()));
        }
    }

    private void processTableTypeKeys(String text, TableConfig tableConfig) {
        tableConfig.setTableTypeKeys(text);
    }

    private void processTableTypeKeysNot(String text, TableConfig tableConfig) {
        if (StringUtils.isNotEmpty((String)text)) {
            List list = StringUtils.asList((String[])text.split(","));
            tableConfig.setTableTitleNotKey(list);
        }
    }

    protected abstract List<String> doLoadContent(Object var1);
}

