/*
 * Decompiled with CFR 0.152.
 */
package com.walker.openocr.table;

import com.walker.openocr.MultipleLine;
import com.walker.openocr.TextBlock;
import com.walker.openocr.table.CellConfigItem;

public class CellObject
implements Comparable<CellObject> {
    private String id;
    private int rowNum = 0;
    private int orderColumn = 0;
    private TextBlock source = null;
    private CellConfigItem cellConfigItem = null;
    private String value = null;

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public CellConfigItem getCellConfigItem() {
        return this.cellConfigItem;
    }

    public void setCellConfigItem(CellConfigItem cellConfigItem) {
        this.cellConfigItem = cellConfigItem;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public void setRowNum(int rowNum) {
        this.rowNum = rowNum;
    }

    public int getOrderColumn() {
        return this.orderColumn;
    }

    public void setOrderColumn(int orderColumn) {
        this.orderColumn = orderColumn;
    }

    public TextBlock getSource() {
        return this.source;
    }

    public void setSource(TextBlock source) {
        this.source = source;
    }

    public boolean isConfigurable() {
        return this.cellConfigItem != null;
    }

    public boolean isConfigNoneCell() {
        this.checkConfigItem();
        return this.cellConfigItem.isNoneCell();
    }

    public boolean isConfigFullRow() {
        this.checkConfigItem();
        return this.cellConfigItem.isFullRow();
    }

    public boolean isConfigTwoLine() {
        this.checkConfigItem();
        return this.cellConfigItem.getMultipleLine() == MultipleLine.TwoLine;
    }

    public boolean isConfigMoreLine() {
        this.checkConfigItem();
        return this.cellConfigItem.getMultipleLine() == MultipleLine.More;
    }

    public boolean isConfigSingleLine() {
        this.checkConfigItem();
        return this.cellConfigItem.getMultipleLine() == MultipleLine.None;
    }

    public int getMinValueSize() {
        this.checkConfigItem();
        return this.cellConfigItem.getMinValueSize();
    }

    private void checkConfigItem() {
        if (this.cellConfigItem == null) {
            throw new IllegalArgumentException("\u5355\u5143\u683c\u4e0d\u662f\u53ef\u914d\u7f6e\u5143\u7d20:" + this.id);
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof CellObject) {
            CellObject cellObject = (CellObject)obj;
            if (cellObject.id.equals(this.id)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[id=");
        sb.append(this.id);
        sb.append(", row=").append(this.rowNum).append(", column=").append(this.orderColumn);
        if (this.source != null) {
            sb.append(", name=").append(this.source.getText());
        }
        if (this.value != null) {
            sb.append(", value=").append(this.value);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public int compareTo(CellObject o) {
        return this.orderColumn - o.orderColumn;
    }
}

