/*
 * Decompiled with CFR 0.152.
 */
package com.walker.openocr.table;

import com.walker.openocr.RecognizeResult;
import com.walker.openocr.TextBlock;
import com.walker.openocr.table.CellConfigItem;
import com.walker.openocr.table.CellObject;
import com.walker.openocr.table.ColumnConfigItem;
import com.walker.openocr.table.ConfigItem;
import com.walker.openocr.table.TableConfig;
import com.walker.openocr.util.TableConfigUtils;
import com.walker.openocr.util.TableObjectUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TableObject
extends RecognizeResult<TableConfig> {
    private TableConfig tableConfig = null;
    protected List<CellObject> otherCellObjectList = new ArrayList<CellObject>();
    private Map<String, CellObject> configItemBlockCache = new HashMap<String, CellObject>();

    public TableObject(TableConfig tableConfig) {
        if (tableConfig == null) {
            throw new IllegalArgumentException("TableConfig is required!");
        }
        this.tableConfig = tableConfig;
    }

    @Override
    public TableConfig getRecognizeConfig() {
        if (this.tableConfig == null) {
            this.logger.error("TableConfig \u4e0d\u5b58\u5728!");
            return null;
        }
        return this.tableConfig;
    }

    public Map<String, CellObject> getTableDataMap() {
        HashMap<String, CellObject> map = new HashMap<String, CellObject>();
        if (this.rowCache.size() == 0) {
            return map;
        }
        for (List list : this.rowCache.values()) {
            for (CellObject co : list) {
                if (!co.isConfigurable()) continue;
                map.put(co.getId(), co);
            }
        }
        return map;
    }

    @Override
    public void calculateValue() {
        int cellSize = 0;
        for (List rowData : this.rowCache.values()) {
            cellSize = rowData.size();
            CellObject current = null;
            String cellValue = null;
            for (int i = 0; i < cellSize; ++i) {
                current = (CellObject)rowData.get(i);
                if (!current.isConfigurable()) continue;
                if (current.isConfigNoneCell()) {
                    cellValue = TableObjectUtils.parseSplitTitleAndValue(current, true);
                } else if (current.isConfigFullRow()) {
                    if (current.isConfigTwoLine()) {
                        List<CellObject> nextLineCells = this.acquireTwoLineCellInfo(current);
                        cellValue = TableObjectUtils.parseFullRowTwoLineValue(rowData, current, nextLineCells);
                    } else if (current.isConfigSingleLine()) {
                        cellValue = TableObjectUtils.parseFullRowTwoLineValue(rowData, current, null);
                    } else if (current.isConfigMoreLine()) {
                        throw new UnsupportedOperationException("\u672a\u5b9e\u73b0\u5b8c\u6574\u884c\uff08\u591a\u884c\u6587\u672c\uff09\u4ee3\u7801");
                    }
                } else if (current.isConfigTwoLine()) {
                    if (this.isExistValueCell(i, rowData)) {
                        nextLineCell = this.acquireTwoLineCell((CellObject)rowData.get(i + 1));
                        if (nextLineCell != null) {
                            this.logger.debug("\u627e\u5230\u7b2c\u4e8c\u884c\u503c:" + nextLineCell.getSource().getText());
                            cellValue = TableObjectUtils.parseCellTwoLineValue((CellObject)rowData.get(i + 1), nextLineCell, false);
                        }
                    } else {
                        nextLineCell = this.acquireTwoLineCell((CellObject)rowData.get(i));
                        if (nextLineCell != null) {
                            this.logger.debug("\u627e\u5230\u7b2c\u4e8c\u884c\u503c2:" + nextLineCell.getSource().getText());
                            cellValue = TableObjectUtils.parseCellTwoLineValue(nextLineCell, null, false);
                        }
                    }
                } else if (current.isConfigSingleLine()) {
                    cellValue = TableObjectUtils.parseSplitTitleAndValue(current, true);
                    if (cellValue == null) {
                        cellValue = this.isExistValueCell(i, rowData) ? ((CellObject)rowData.get(i + 1)).getSource().getText() : TableObjectUtils.parseSplitTitleAndValue(current, true);
                    }
                } else {
                    throw new UnsupportedOperationException("\u672a\u5b9e\u73b0\u4ee3\u7801\uff0c\u4e0d\u786e\u5b9a\u7684\u5355\u5143\u683c:" + current.getSource().getText());
                }
                current.setValue(cellValue);
            }
        }
    }

    private boolean isExistValueCell(int currentIndex, List<CellObject> rowData) {
        return currentIndex + 1 < rowData.size();
    }

    protected CellObject acquireTwoLineCell(CellObject cellObject) {
        return TableObjectUtils.findNextRowCell(cellObject, this.otherCellObjectList, this.tableConfig.getMultiLineTolerance(), this.tableConfig.getCellTolerance());
    }

    protected List<CellObject> acquireTwoLineCellInfo(CellObject configurableCellObject) {
        if (!configurableCellObject.isConfigTwoLine()) {
            throw new IllegalArgumentException("acquireTwoLineCellInfo:\u5355\u5143\u683c\u4e0d\u662f\u4e24\u884c\u914d\u7f6e\uff0c\u65e0\u6cd5\u8c03\u7528\u8be5\u65b9\u6cd5");
        }
        return TableObjectUtils.findNextRowInfo(configurableCellObject, this.otherCellObjectList, this.tableConfig.getMultiLineTolerance(), this.tableConfig.getCellTolerance());
    }

    @Override
    public void sortCellObjectList() {
        CellObject target = null;
        Iterator<CellObject> it = this.otherCellObjectList.iterator();
        block0: while (it.hasNext()) {
            target = it.next();
            List rowSet = null;
            boolean sameRow = false;
            for (Map.Entry entry : this.rowCache.entrySet()) {
                rowSet = (List)entry.getValue();
                sameRow = TableObjectUtils.isInSameRow((CellObject)rowSet.get(0), target, this.tableConfig.getCellTolerance());
                if (!sameRow) continue;
                this.logger.debug("\u627e\u5230\u5339\u914d\u884c:" + entry.getKey() + ", target=" + target.getSource().getText());
                rowSet.add(target);
                it.remove();
                continue block0;
            }
        }
        for (List list : this.rowCache.values()) {
            TableObjectUtils.sortColumnCellList(list);
        }
    }

    @Override
    public void addTextBlock(TextBlock textBlock) {
        CellObject cellObject = new CellObject();
        cellObject.setSource(textBlock);
        ConfigItem configItem = this.tableConfig.findConfigItem(textBlock.getText());
        if (configItem != null) {
            if (configItem instanceof ColumnConfigItem) {
                throw new UnsupportedOperationException("\u672a\u5b9e\u73b0\u4ee3\u7801:ColumnConfigItem");
            }
            if (configItem instanceof CellConfigItem) {
                CellConfigItem cellConfigItem = (CellConfigItem)configItem;
                cellObject.setCellConfigItem(cellConfigItem);
                cellObject.setId(cellConfigItem.getId());
                cellObject.setRowNum(cellConfigItem.getOrderNum());
            }
            this.putCellObjectToRowCache(cellObject, configItem);
        } else {
            cellObject.setId(this.generateCellId());
            this.otherCellObjectList.add(cellObject);
        }
    }

    private void putCellObjectToRowCache(CellObject cellObject, ConfigItem configItem) {
        CellObject textBlockExist = this.configItemBlockCache.get(configItem.getId());
        if (textBlockExist == null) {
            this.configItemBlockCache.put(configItem.getId(), cellObject);
            this.putOneRowCache(cellObject);
        } else {
            CellObject matchedCellObject = this.findMaxScoreCellObject(textBlockExist, cellObject, configItem);
            this.configItemBlockCache.put(configItem.getId(), matchedCellObject);
            this.putOneRowCache(matchedCellObject);
        }
    }

    private CellObject findMaxScoreCellObject(CellObject textBlockExist, CellObject cellObject, ConfigItem configItem) {
        float existScore = TableConfigUtils.getSimpleSimilarScore(configItem.getName(), textBlockExist.getSource().getText());
        float newScore = TableConfigUtils.getSimpleSimilarScore(configItem.getName(), cellObject.getSource().getText());
        if (newScore > existScore) {
            this.logger.debug("\u65b0\u6587\u672c\u5feb\u66f4\u52a0\u5339\u914d\u914d\u7f6e\u9879:" + configItem.getName() + ", newScore=" + newScore + ", text=" + cellObject.getSource().getText());
            return cellObject;
        }
        this.logger.debug("\u5df2\u6709\u6587\u672c\u5feb\u66f4\u9002\u5408:" + configItem.getName() + ", existScore=" + existScore + ", text=" + textBlockExist.getSource().getText());
        return textBlockExist;
    }

    private void putOneRowCache(CellObject cellObject) {
        LinkedList<CellObject> list = (LinkedList<CellObject>)this.rowCache.get(cellObject.getRowNum());
        if (list == null) {
            list = new LinkedList<CellObject>();
            this.rowCache.put(cellObject.getRowNum(), list);
        }
        if (!list.contains(cellObject)) {
            list.add(cellObject);
        }
    }

    private String generateCellId() {
        return String.valueOf(System.nanoTime());
    }

    @Override
    public void printRowCache() {
        super.printRowCache();
        this.logger.debug("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        for (CellObject other : this.otherCellObjectList) {
            this.logger.debug(other.toString());
        }
    }
}

