/*
 * Decompiled with CFR 0.152.
 */
package com.walker.openocr.util;

import com.walker.infrastructure.utils.FileCopyUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.ClassPathResource;

public class FileReaderUtils {
    public static final void saveJson2File(String json, String filePath) {
        try {
            FileCopyUtils.copy((byte[])json.getBytes(), (File)new File(filePath));
        }
        catch (IOException e) {
            throw new RuntimeException("json\u5199\u5165\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
    }

    public static final InputStream getClasspathInputStream(String fileName) throws IOException {
        ClassPathResource resource = new ClassPathResource(fileName);
        return resource.getInputStream();
    }

    public static List<String> getFileLines(InputStream inputStream) {
        ArrayList<String> content = new ArrayList<String>(64);
        try (InputStreamReader read = new InputStreamReader(inputStream, "UTF-8");
             BufferedReader bufferedReader = new BufferedReader(read);){
            String lineTxt;
            while ((lineTxt = bufferedReader.readLine()) != null) {
                content.add(lineTxt.trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u51fa\u9519");
        }
        return content;
    }

    public static List<String> getFileLines(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            System.out.println("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8bfb\u53d6\u5185\u5bb9\uff1a" + filePath);
            return null;
        }
        ArrayList<String> content = new ArrayList<String>(64);
        try (InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
             BufferedReader bufferedReader = new BufferedReader(read);){
            if (file.isFile() && file.exists()) {
                String lineTxt;
                while ((lineTxt = bufferedReader.readLine()) != null) {
                    content.add(lineTxt.trim());
                }
            } else {
                System.out.println("\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6587\u4ef6");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u51fa\u9519");
        }
        return content;
    }
}

