/*
 * Decompiled with CFR 0.152.
 */
package com.walker.openocr.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;

public class JsonUtils {
    public static final ObjectMapper objectMapper = new ObjectMapper();

    public static String objectToJsonString(Object javaObject) throws Exception {
        return objectMapper.writeValueAsString(javaObject);
    }

    public static byte[] objectToBytes(Object javaObject) throws Exception {
        if (javaObject == null) {
            return null;
        }
        return objectMapper.writeValueAsBytes(javaObject);
    }

    public static <T> T jsonStringToObject(String json, Class<T> clazz) throws Exception {
        return (T)objectMapper.readValue(json, clazz);
    }

    public static ObjectNode jsonStringToObjectNode(String json) throws Exception {
        return JsonUtils.jsonStringToObject(json, ObjectNode.class);
    }

    public static ObjectNode mapToObjectNode(Map<String, Object> map) {
        ObjectNode node = objectMapper.createObjectNode();
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                node.put(entry.getKey(), entry.getValue().toString());
            }
        }
        return node;
    }
}

