/*
 * Decompiled with CFR 0.152.
 */
package com.walker.openocr.util;

import com.walker.openocr.MultipleLine;
import com.walker.openocr.table.CellConfigItem;
import com.walker.openocr.table.ColumnConfigItem;
import com.walker.openocr.table.TableConfig;
import com.walker.openocr.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableConfigUtils {
    private static final Logger logger = LoggerFactory.getLogger(TableConfigUtils.class);

    public static CellConfigItem acquireCellConfig(String id, String name, boolean noneCell, int orderNum, String align, String endFlag, MultipleLine multipleLine, String dataType, boolean fullRow, int minValueSize) {
        CellConfigItem cell = new CellConfigItem();
        cell.setId(id);
        cell.setName(name);
        cell.setNoneCell(noneCell);
        cell.setOrderNum(orderNum);
        if (align != null && !align.equals("")) {
            cell.setAlign(align);
        }
        cell.setEndFlag(endFlag);
        if (multipleLine != null) {
            cell.setMultipleLine(multipleLine);
        }
        cell.setDataType(dataType);
        cell.setFullRow(fullRow);
        cell.setMinValueSize(minValueSize);
        return cell;
    }

    public static ColumnConfigItem acquireColumnConfig(String id, String name, int orderNum, String align, MultipleLine multipleLine, int rowTotal) {
        ColumnConfigItem item = new ColumnConfigItem();
        item.setId(id);
        item.setName(name);
        item.setOrderNum(orderNum);
        if (align != null && !align.equals("")) {
            item.setAlign(align);
        }
        if (multipleLine != null) {
            item.setMultipleLine(multipleLine);
        }
        item.setRowTotal(rowTotal);
        return item;
    }

    public static final boolean isCellConfigItem(CellConfigItem cellConfigItem, String text, TableConfig tableConfig) {
        String[] titleValue;
        String configName = cellConfigItem.getName();
        if (text.contains(":") && (titleValue = text.split(":"))[0].equals(configName)) {
            return true;
        }
        if (text.indexOf(configName) >= 0) {
            logger.debug("\u5b57\u7b26\u4e32\u5b8c\u5168\u5339\u914d\u5230\u6807\u9898:" + configName + ", text=" + text);
            return true;
        }
        float matchPercent = TableConfigUtils.getSimpleSimilarScore(configName, text);
        if (matchPercent >= tableConfig.getTitleTolerance()) {
            logger.debug("\u6839\u636e\u6807\u9898\u767e\u5206\u6bd4\u627e\u5230:" + configName + ", percent=" + matchPercent + ", text=" + text);
            return true;
        }
        return false;
    }

    public static float getSimpleSimilarScore(String configName, String text) {
        if (TextUtils.isEmpty(configName) || TextUtils.isEmpty(text)) {
            return 0.0f;
        }
        if (text.length() > configName.length()) {
            return 0.0f;
        }
        float count = configName.length();
        float matchSize = 0.0f;
        for (String s : configName.split("")) {
            if (!text.contains(s)) continue;
            matchSize += 1.0f;
        }
        return matchSize / count;
    }
}

