package com.walker.openocr;

public class FaceDetectResult {

    public int getFaceNum() {
        return faceNum;
    }

    public void setFaceNum(int faceNum) {
        this.faceNum = faceNum;
    }

    public String getFaceToken() {
        return faceToken;
    }

    public void setFaceToken(String faceToken) {
        this.faceToken = faceToken;
    }

    public double getLeft() {
        return left;
    }

    public void setLeft(double left) {
        this.left = left;
    }

    public double getTop() {
        return top;
    }

    public void setTop(double top) {
        this.top = top;
    }

    public double getWidth() {
        return width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public double getFaceProbability() {
        return faceProbability;
    }

    public void setFaceProbability(double faceProbability) {
        this.faceProbability = faceProbability;
    }

    public int getAge() {
        return age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public boolean isSmile() {
        return smile;
    }

    public void setSmile(boolean smile) {
        this.smile = smile;
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public boolean isGlasses() {
        return glasses;
    }

    public void setGlasses(boolean glasses) {
        this.glasses = glasses;
    }

    public String getFaceType() {
        return faceType;
    }

    public void setFaceType(String faceType) {
        this.faceType = faceType;
    }

    public double getFaceTypeProbability() {
        return faceTypeProbability;
    }

    public void setFaceTypeProbability(double faceTypeProbability) {
        this.faceTypeProbability = faceTypeProbability;
    }

    private int faceNum = 1;
    private String faceToken;
    private double left = 0;
    private double top = 0;
    private double width = 0;
    private double height = 0;
    private double faceProbability = 0; // 人脸置信度，范围【0~1】，代表这是一张人脸的概率，0最小、1最大
    private int age = 0;
    private boolean smile = false;
    private String gender = null;       // 性别，male:男性 female:女性
    private boolean glasses = false;    // 是否带眼镜，face_field包含glasses时返回
    private String faceType = null;     // 人脸类型，human: 真实人脸 cartoon: 卡通人脸
    private double faceTypeProbability = 0; // 人脸类型判断正确的置信度，范围【0~1】，0代表概率最小、1代表最大

}
