package com.walker.openocr;

import com.walker.openocr.util.FaceItem;

/**
 * 人脸识别规范定义。
 * @author 时克英
 * @date 2024-01-30
 */
public interface FaceRecognize {

    /**
     * 人脸检测
     * <pre>
     *     图片类型
     * 1) BASE64:图片的base64值，base64编码后的图片数据，编码后的图片大小不超过2M；
     * 2) URL:图片的 URL地址( 可能由于网络等原因导致下载图片时间过长)；
     * 3) FACE_TOKEN: 人脸图片的唯一标识，调用人脸检测接口时，会为每个人脸图片赋予一个唯一的FACE_TOKEN，同一张图片多次检测得到的FACE_TOKEN是同一个。
     * </pre>
     * @param image 图像内容，根据type定。
     * @param imageType 图像类型
     * @param option
     * @return
     */
    FaceDetectResult detect(String image, String imageType, Object option);

//    /**
//     * 两个人脸对比。
//     * @return
//     */
//    FaceMatchResult match();

    double matchTwoFace(FaceItem face1, FaceItem face2);

    double matchTwoImageFile(String file1, String file2);

    /**
     * 对比两张照片，判断是否同一人
     * @param photo_live_base64
     * @param imageBase64
     * @return
     */
    double matchTwoImageBase64(String photo_live_base64, String imageBase64);

    /**
     * 对比两张照片，判断是否同一人，增加了一个输入参数（活体级别）
     * @param photo_live_base64
     * @param imageBase64
     * @param livenessControl 活体检测选项：LOW/NORMAL/HIGH
     * @return
     */
    double matchTwoImageBase64(String photo_live_base64, String imageBase64, String livenessControl);
}
