package com.walker.openocr;

/**
 * 单元格多行类别定义。
 * @author 时克英
 * @date 2022-08-31
 */
public enum MultipleLine {

    None{
        public String getIndex(){
            return LINE_NONE;
        }
    },
    TwoLine{
        public String getIndex(){
            return LINE_TWO;
        }
    },
    MaybeTwoLine{
        public String getIndex(){
            return LINE_MAYBE_TWO;
        }
    },
    More{
        public String getIndex(){
            return LINE_MORE;
        }
    };

    public String getIndex(){
        throw new AbstractMethodError();
    }

    public static MultipleLine getType(String index){
        if(index.equals(LINE_NONE)){
            return None;
        } else if(index.equals(LINE_TWO)){
            return TwoLine;
        } else if (index.equals(LINE_MAYBE_TWO)) {
            return MaybeTwoLine;
        } else if (index.equals(LINE_MORE)) {
            return More;
        } else {
            throw new UnsupportedOperationException("不支持该类型：" + index);
        }
    }

    public static final String LINE_NONE = "none";
    public static final String LINE_TWO = "two_line";
    public static final String LINE_MAYBE_TWO = "maybe_two_line";
    public static final String LINE_MORE = "more";
}
