package com.walker.openocr;

import com.walker.openocr.table.CellObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * 识别解析结果对象定义，方便抽象复用代码。
 * @author 时克英
 * @date 2022-09-06
 */
public abstract class RecognizeResult<T> {

    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    protected Map<Integer, List<CellObject>> rowCache = new TreeMap<>();

    public void printRowCache(){
        List<CellObject> data = null;
        for(Map.Entry<Integer, List<CellObject>> entry : this.rowCache.entrySet()){
            logger.debug("第 " + entry.getKey() + " 行 ==========================================");
            data = entry.getValue();
            if(data != null){
                for(CellObject co : data){
                    logger.debug(co.toString());
                }
            }
        }
    }

    public abstract void addTextBlock(TextBlock textBlock);

    /**
     * 添加完文本块后，排序，把相关行内容放在一起，并对每一行进行列排序。
     */
    public abstract void sortCellObjectList();

    /**
     * 计算标题对应的值。
     */
    public abstract void calculateValue();

    /**
     * 返回对象（配置）类别，如：TableConfig / IdCardConfig。
     * @return
     */
    public abstract T getRecognizeConfig();
}
