package com.walker.openocr;

/**
 * 数据块，从OCR服务获取的最小文本单元，包括：坐标位置、内容、分值。
 * @author 时克英
 * @date 2022-08-30
 */
public class TextBlock {

    private String text;
    // 文本开始位置
    private float[] startPosition;
    // 文本结束位置
    private float[] endPosition;

    // 置信度（分值）
    private float score;

    public TextBlock(){}

    public TextBlock(String text, float[] start, float[] end, float score){
        this.text = text;
        this.startPosition = start;
        this.endPosition = end;
        this.score = score;
    }

    public String getText() {
        return text;
    }

    public TextBlock setText(String text) {
        this.text = text;
        return this;
    }

    public float[] getStartPosition() {
        return startPosition;
    }

    public TextBlock setStartPosition(float[] startPosition) {
        this.startPosition = startPosition;
        return this;
    }

    public float[] getEndPosition() {
        return endPosition;
    }

    public TextBlock setEndPosition(float[] endPosition) {
        this.endPosition = endPosition;
        return this;
    }

    public float getScore() {
        return score;
    }

    public TextBlock setScore(float score) {
        this.score = score;
        return this;
    }

    @Override
    public String toString(){
        return new StringBuilder("[text=").append(this.text)
                .append(", start=").append(this.startPosition[0]).append(",").append(this.startPosition[1])
                .append(", end=").append(this.endPosition[0]).append(",").append(this.endPosition[1])
                .append(", score=").append(this.score)
                .append("]").toString();
    }
}
