package com.walker.openocr;

import java.util.List;

/**
 * 定义识别后文本内容解析器，解析成业务可用的内容，如：一段文字、表格等对象。
 * @param <T> 要返回的解析结果对象类型
 * @param <C> 解析配置参数对象类型
 * @author 时克英
 * @date 2022-08-30
 */
public interface TextResolver<T,C> {

    /**
     * 解析成特定的对象。
     * @param dataList 从OCR服务中获取的文本集合。
     * @return
     */
    T resolve(List<TextBlock> dataList, List<C> configList);

    /**
     * 设置识别类型
     * @param ocrType
     */
    void setOcrType(OcrType ocrType);

    OcrType getOcrType();
}
