package com.walker.openocr.idcard;

import java.util.ArrayList;
import java.util.List;

/**
 * 身份证解析配置对象，身份证解析过程只需要一个配置全局对象，无需重复创建。
 * @author 时克英
 * @date 2022-09-06
 */
public class IdCardConfig {

    private int cellTolerance = 12;

    // 多行文本，每行之间容差距离（匹配2行单元格）
    private int multiLineTolerance = 25;

    private int totalRows = 5;

    // 身份证正面关键词
    private List<String> idCardFrontKeys = new ArrayList<>(8);

    public List<String> getIdCardFrontKeys() {
        return idCardFrontKeys;
    }

    public int getCellTolerance() {
        return cellTolerance;
    }

    public void setCellTolerance(int cellTolerance) {
        this.cellTolerance = cellTolerance;
    }

    public int getMultiLineTolerance() {
        return multiLineTolerance;
    }

    public void setMultiLineTolerance(int multiLineTolerance) {
        this.multiLineTolerance = multiLineTolerance;
    }

    public int getTotalRows() {
        return totalRows;
    }

    public void setTotalRows(int totalRows) {
        this.totalRows = totalRows;
    }

    public IdCardConfig(){
        if(this.idCardFrontKeys.size() == 0){
            this.idCardFrontKeys.add(VALUE_NAME);
            this.idCardFrontKeys.add(VALUE_SEX);
            this.idCardFrontKeys.add(VALUE_NATION);
            this.idCardFrontKeys.add(VALUE_ADDRESS);
            this.idCardFrontKeys.add(VALUE_NUMBER);
            this.idCardFrontKeys.add(VALUE_BIRTHDAY);
        }
    }

    /**
     * 设置身份证正面关键词。系统默认会初始化这些参数。
     * @param text 如：姓名、性别、公民身份号码
     */
    public void setIdCardFrontKeys(String text){
        if(text == null || text.equals("")){
            throw new IllegalArgumentException("idCardKeys is required!");
        }
        String[] array = text.split(",");
        for (String one : array){
            this.idCardFrontKeys.add(one);
        }
    }

    public static final String VALUE_NAME = "姓名";
    public static final String VALUE_SEX = "性别";
    public static final String VALUE_BIRTHDAY = "出生";
    public static final String VALUE_NATION = "民族";
    public static final String VALUE_ADDRESS = "住址";
    public static final String VALUE_NUMBER = "公民身份号码";

    public static final String SEX_MALE = "男";
    public static final String SEX_FEMALE = "女";
}
