package com.walker.openocr.idcard;

import com.walker.openocr.AbstractTextResolver;
import com.walker.openocr.OcrType;
import com.walker.openocr.TextBlock;

import java.util.List;

public class IdCardTextResolver extends AbstractTextResolver<IdCardObject, IdCardConfig> {

    public IdCardTextResolver(){
        this.setOcrType(OcrType.TextIdCard);
    }

    @Override
    protected IdCardObject doResolveGeneric(List<TextBlock> dataList, List<IdCardConfig> configList) {
        throw new UnsupportedOperationException("不支持该方法");
    }

    @Override
    protected IdCardObject doResolveTable(List<TextBlock> dataList, List<IdCardConfig> configList) {
        throw new UnsupportedOperationException("不支持该方法");
    }

    @Override
    protected IdCardObject doResolveIdCard(List<TextBlock> dataList, List<IdCardConfig> configList) {
        if(configList == null || configList.size() == 0){
            throw new IllegalArgumentException("没有配置身份证参数设置");
        }

        IdCardConfig idCardConfig = configList.get(0);
        IdCardObject idCardObject = new IdCardObject(idCardConfig);

        for(TextBlock tb : dataList){
            idCardObject.addTextBlock(tb);
        }

        idCardObject.sortCellObjectList();
        idCardObject.calculateValue();
        idCardObject.printRowCache();
        return idCardObject;
    }
}
