package com.walker.openocr.oil;

import com.walker.openocr.TextBlock;
import com.walker.openocr.table.CellObject;
import com.walker.openocr.table.TableConfig;
import com.walker.openocr.table.TableObject;
import com.walker.openocr.table.TableTextResolver;

import java.util.List;

@Deprecated
public class OilPrintResolver extends TableTextResolver {

    public OilPrintResolver(){
        super();
    }

    @Override
    protected TableObject doResolveTable(List<TextBlock> dataList, List<TableConfig> configList) {

        double money = 0;
        for(TextBlock tb : dataList){
//            Class<?> type = StringUtils.getNumbericType(tb.getText());
//            if(type == Double.class || type == Long.class){
//            }
            try{
                money = Double.parseDouble(tb.getText());
            } catch (Exception ex){
                continue;
            }
            if(money < 0){
                logger.debug("找到了单据上负数，可能是金额：{}", money);
                break;
            }
        }

        TableObject tableObject = super.doResolveTable(dataList, configList);

        if(money != 0){
            CellObject jineCellObject = new CellObject();
            jineCellObject.setId("jin_e");
            jineCellObject.setValue(String.valueOf(money));
            tableObject.getTableDataMap().put("jin_e", jineCellObject);
        }
        return tableObject;
    }
}
