package com.walker.openocr.support;

import com.baidu.aip.face.AipFace;
import com.baidu.aip.face.MatchRequest;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.openocr.AbstractFaceRecognize;
import com.walker.openocr.FaceDetectResult;
import com.walker.openocr.util.FaceItem;
import com.walker.openocr.util.FaceUtils;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class BaiduFaceRecognize extends AbstractFaceRecognize {

//    private HashMap<String, String> options;

    @Override
    public FaceDetectResult detect(String image, String imageType, Object option) {
        throw new UnsupportedOperationException("未实现人脸检测接口");
    }

    @Override
    public double matchTwoFace(FaceItem face1, FaceItem face2){
        logger.debug(face1.getFaceToken() + ", " + face2.getFaceToken());
        MatchRequest req1 = new MatchRequest(face1.getFaceToken(), "FACE_TOKEN");
        MatchRequest req2 = new MatchRequest(face2.getFaceToken(), "FACE_TOKEN");
        ArrayList<MatchRequest> requests = new ArrayList<MatchRequest>();
        requests.add(req1);
        requests.add(req2);

        JSONObject res = client.match(requests);
        logger.info("matchTwoFace(FaceItem) result = {}", res);
        return 0;
    }

    @Override
    public double matchTwoImageFile(String file1, String file2){
        MatchRequest req1 = new MatchRequest(FaceUtils.getImageBase64(file1), "BASE64");
        MatchRequest req2 = new MatchRequest(FaceUtils.getImageBase64(file2), "BASE64");
        List<MatchRequest> requests = new ArrayList<MatchRequest>();
        requests.add(req1);
        requests.add(req2);

        try{
            return this.doMatchProcess(requests);
        } catch(RuntimeException ex){
            throw ex;
        }
    }

    @Override
    public double matchTwoImageBase64(String photo_live_base64, String imageBase64){
        // 活体检测选项：LOW/NORMAL/HIGH
        MatchRequest req1 = new MatchRequest(photo_live_base64, "BASE64","LIVE", "NORMAL","LOW");
        MatchRequest req2 = new MatchRequest(imageBase64, "BASE64", "CERT", null, null);
        ArrayList<MatchRequest> requests = new ArrayList<MatchRequest>();
        requests.add(req1);
        requests.add(req2);

        try{
            return this.doMatchProcess(requests);
        } catch(RuntimeException ex){
            throw ex;
        }
    }

    @Override
    public double matchTwoImageBase64(String photo_live_base64, String imageBase64, String livenessControl){
        // 活体检测选项：LOW/NORMAL/HIGH
        MatchRequest req1 = new MatchRequest(photo_live_base64, "BASE64","LIVE", "NORMAL",livenessControl);
        MatchRequest req2 = new MatchRequest(imageBase64, "BASE64", "CERT", null, null);
        ArrayList<MatchRequest> requests = new ArrayList<MatchRequest>();
        requests.add(req1);
        requests.add(req2);

        try{
            return this.doMatchProcess(requests);
        } catch(RuntimeException ex){
            throw ex;
        }
    }

    private double doMatchProcess(List<MatchRequest> requests){
        JSONObject res = client.match(requests);
        if(res == null){
//			logger.error("调用matchTwoImage接口，返回空数据");
            throw new RuntimeException("调用matchTwoImage接口，返回空数据");
        }
        logger.info("face match result = {}", res);

        if(res.getInt("error_code") != 0){
            logger.error("调用detect接口，返回错误数据：" + res.getString("error_msg"));
            throw new RuntimeException(res.getString("error_msg"));
        }

        JSONObject result = res.getJSONObject("result");
        return result.getDouble("score");
    }

    public void checkFaceClient(){
        if(this.client == null){
            if(StringUtils.isEmpty(this.appId) || StringUtils.isEmpty(this.apiKey) || StringUtils.isEmpty(this.secretKey)){
                throw new IllegalArgumentException("appId, apiKey, secretKey为空，无法初始化百度OCR client!");
            }
            client = new AipFace(this.appId, this.apiKey, this.secretKey);
            // 可选：设置网络连接参数
            client.setConnectionTimeoutInMillis(2000);
            client.setSocketTimeoutInMillis(60000);

            // 传入可选参数调用接口
//            options = new HashMap<String, String>();
//            options.put("language_type", "CHN_ENG");
//            options.put("detect_direction", "true");
//            options.put("detect_language", "true");
//            options.put("probability", "true");
            logger.info("百度: AipFace初始化成功");
        }
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getApiKey() {
        return apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    private String appId;
    private String apiKey;
    private String secretKey;
    private AipFace client;
}
