package com.walker.openocr.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;

import java.util.Map;

public class JsonUtils {

    public static final ObjectMapper objectMapper = new ObjectMapper();

    /**
     * 把java对象转换为JSON字符串
     * @param javaObject
     * @return
     * @throws RuntimeException
     */
    public static String objectToJsonString(Object javaObject) throws Exception{
        return objectMapper.writeValueAsString(javaObject);
//        try {
//        } catch (JsonProcessingException e) {
//            throw new RuntimeException("objectToJsonString,对象转json字符串异常：" + e.getMessage(), e);
//        }
    }

    public static byte[] objectToBytes(Object javaObject) throws Exception{
        if(javaObject == null){
            return null;
        }
        return objectMapper.writeValueAsBytes(javaObject);
    }

    public static <T> T jsonStringToObject(String json, Class<T> clazz) throws Exception{
        return objectMapper.readValue(json, clazz);
    }

    public static ObjectNode jsonStringToObjectNode(String json) throws Exception{
        return jsonStringToObject(json, ObjectNode.class);
    }

    public static ObjectNode mapToObjectNode(Map<String, Object> map){
        ObjectNode node = objectMapper.createObjectNode();
        if(map != null){
            for(Map.Entry<String, Object> entry : map.entrySet()){
                node.put(entry.getKey(), entry.getValue().toString());
            }
        }
        return node;
    }

}
