package com.walker.openocr.util;

import com.walker.openocr.Constants;
import com.walker.openocr.MultipleLine;
import com.walker.openocr.table.CellConfigItem;
import com.walker.openocr.table.ColumnConfigItem;
import com.walker.openocr.table.TableConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableConfigUtils {

    private static final Logger logger = LoggerFactory.getLogger(TableConfigUtils.class);

    public static CellConfigItem acquireCellConfig(String id
            , String name, boolean noneCell, int orderNum, String align, String endFlag
            , MultipleLine multipleLine, String dataType, boolean fullRow, int minValueSize){
        CellConfigItem cell = new CellConfigItem();
        cell.setId(id);
        cell.setName(name);
        cell.setNoneCell(noneCell);
        cell.setOrderNum(orderNum);
        if(align != null && !align.equals("")){
            cell.setAlign(align);
        }
        cell.setEndFlag(endFlag);
        if(multipleLine != null){
            cell.setMultipleLine(multipleLine);
        }
        cell.setDataType(dataType);
        cell.setFullRow(fullRow);
        cell.setMinValueSize(minValueSize);
        return cell;
    }

    public static ColumnConfigItem acquireColumnConfig(String id, String name
            , int orderNum, String align, MultipleLine multipleLine, int rowTotal){
        ColumnConfigItem item = new ColumnConfigItem();
        item.setId(id);
        item.setName(name);
        item.setOrderNum(orderNum);
        if(align != null && !align.equals("")){
            item.setAlign(align);
        }
        if(multipleLine != null){
            item.setMultipleLine(multipleLine);
        }
//        item.setDataType();
        item.setRowTotal(rowTotal);
        return item;
    }

    public static final boolean isCellConfigItem(CellConfigItem cellConfigItem, String text, TableConfig tableConfig){
        // 1.先检查名字中是否带有冒号，如果存在说明有明确标题名称
        // 2.检查字符串匹配，是否包含配置的名称，如果存在则说明该单元格：标题+内容
        // 3.如果都没有，按照表格配置相似百分比计算
        // 4.以上都没有，说明是其他字段，返回false
        String configName = cellConfigItem.getName();
        if(text.contains(Constants.COLON_EN)){
            String[] titleValue = text.split(Constants.COLON_EN);
            if(titleValue[0].equals(configName)){
                return true;
            }
        }

        // 2
        if(text.indexOf(configName) >= 0){
            logger.debug("字符串完全匹配到标题:" + configName + ", text=" + text);
            return true;
        }

        // 3
//        float count = 0;
//        float matchSize = 0;
//        for(String s : configName.split("")){
//            count++;
//            if(text.contains(s)){
//                matchSize++;
//            }
//        }
//        float matchPercent = matchSize / count;
        float matchPercent = getSimpleSimilarScore(configName, text);
        if(matchPercent >= tableConfig.getTitleTolerance()){
            logger.debug("根据标题百分比找到:" + configName + ", percent=" + matchPercent + ", text=" + text);
            return true;
        }

        return false;
    }

    /**
     * 返回给定字符串与对比字符串（configName）的匹配度分值：0~1
     * @param configName 给定的标准字符串
     * @param text 输入要比较的字符串
     * @return
     */
    public static float getSimpleSimilarScore(String configName, String text){
        if(TextUtils.isEmpty(configName) || TextUtils.isEmpty(text)){
            return 0;
        }
        if(text.length() > configName.length()){
            // 如果给定识别字符串比'标准字符串'大，说明明显不匹配
            return 0;
        }
//        if(text.length() < configName.length()){
//            // 如果给定字符串比'标准'字符串少，则肯定不匹配
//            return 0;
//        }
//        float count = text.length();
        float count = configName.length();
        float matchSize = 0;
        for(String s : configName.split(TextUtils.EMPTY_VALUE)){
            if(text.contains(s)){
                matchSize++;
            }
        }
        return  matchSize / count;
    }
}
