package com.walker.openocr.vehicle;

import com.walker.openocr.AbstractValueParser;
import com.walker.openocr.util.TextUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 车辆识别码属性值解析实现。
 * @author 时克英
 * @date 2022-09-27
 */
public class IdValueParser extends AbstractValueParser<String> {

    private List<String> allList = new ArrayList<>();
    private List<String> firstManuList = new ArrayList<>();

    public IdValueParser(){
        this.allList.add("0");
        this.allList.add("1");
        this.allList.add("2");
        this.allList.add("3");
        this.allList.add("4");
        this.allList.add("5");
        this.allList.add("6");
        this.allList.add("7");
        this.allList.add("8");
        this.allList.add("9");
        this.allList.add("A");
        this.allList.add("B");
        this.allList.add("C");
        this.allList.add("D");
        this.allList.add("E");
        this.allList.add("F");
        this.allList.add("G");
        this.allList.add("H");
        this.allList.add("J");
        this.allList.add("K");
        this.allList.add("L");
        this.allList.add("M");
        this.allList.add("N");
        this.allList.add("P");
        this.allList.add("R");
        this.allList.add("S");
        this.allList.add("T");
        this.allList.add("U");
        this.allList.add("V");
        this.allList.add("W");
        this.allList.add("X");
        this.allList.add("Y");
        this.allList.add("Z");

        this.firstManuList.add("1");
        this.firstManuList.add("2");
        this.firstManuList.add("3");
        this.firstManuList.add("4");
        this.firstManuList.add("6");
        this.firstManuList.add("9");
        this.firstManuList.add("W");
        this.firstManuList.add("T");
        this.firstManuList.add("J");
        this.firstManuList.add("S");
        this.firstManuList.add("K");
        this.firstManuList.add("L");
        this.firstManuList.add("V");
        this.firstManuList.add("R");
        this.firstManuList.add("Y");
        this.firstManuList.add("Z");
    }

    @Override
    public String getValue(Object input) {
        if(this.isTypeValue(input)){
            return input.toString();
        }
        return null;
    }

    @Override
    public boolean isTypeValue(Object input) {
        if(TextUtils.isEmpty(input)){
            return false;
        }
        String text = input.toString();
        if(text.length() != 17){
            return false;
        }
        if(!this.firstManuList.contains(text.substring(0,1))){
            // 第一位不是供应商信息
            return false;
        }
        String[] everyOne = text.split(TextUtils.EMPTY_VALUE);
        for(String s : everyOne){
            if(!this.allList.contains(s)){
                // 只要有一个字符不再规定范围就是错误识别码
                return false;
            }
        }
        return true;
    }
}
