/*
 * Decompiled with CFR 0.152.
 */
package com.walker.openocr;

import com.walker.openocr.OcrType;
import com.walker.openocr.TextBlock;
import com.walker.openocr.TextResolver;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTextResolver<T, C>
implements TextResolver<T, C> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private OcrType ocrType = null;

    @Override
    public T resolve(List<TextBlock> dataList, List<C> configList) {
        if (dataList == null || dataList.size() == 0) {
            return null;
        }
        if (this.ocrType == OcrType.TextGeneric) {
            return this.doResolveGeneric(dataList, configList);
        }
        if (this.ocrType == OcrType.TextTable) {
            return this.doResolveTable(dataList, configList);
        }
        if (this.ocrType == OcrType.TextIdCard) {
            return this.doResolveIdCard(dataList, configList);
        }
        throw new UnsupportedOperationException("\u6682\u672a\u5b9e\u73b0\u89e3\u6790\u7c7b\u578b\uff1a" + this.ocrType.getIndex());
    }

    @Override
    public void setOcrType(OcrType ocrType) {
        if (ocrType == null) {
            this.logger.error("ocrType is null!");
            return;
        }
        this.ocrType = ocrType;
    }

    @Override
    public OcrType getOcrType() {
        return this.ocrType;
    }

    protected abstract T doResolveGeneric(List<TextBlock> var1, List<C> var2);

    protected abstract T doResolveTable(List<TextBlock> var1, List<C> var2);

    protected abstract T doResolveIdCard(List<TextBlock> var1, List<C> var2);
}

